/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.P4JLog;
import com.perforce.p4java.core.P4JUserGroup;
import com.perforce.p4java.impl.generic.core.P4JServerResourceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JUserGroupImpl
extends P4JServerResourceImpl
implements P4JUserGroup {
    public static final String UNSET_STR = "unset";
    public static final String UNLIMITED_STR = "unlimited";
    private String name = null;
    private int maxResults = 0;
    private int maxScanRows = 0;
    private int maxLockTime = 0;
    private int timeout = 0;
    private boolean subGroup = false;
    private List<String> subgroups = null;
    private List<String> owners = null;
    private List<String> users = null;

    public P4JUserGroupImpl() {
        super(false, false, false, false);
    }

    public P4JUserGroupImpl(Map<String, Object> map) {
        super(true, false, false, false);
        if (map != null) {
            try {
                this.name = (String)map.get("Group");
                this.maxLockTime = this.parseGroupIntValue((String)map.get("MaxLockTime"));
                this.maxResults = this.parseGroupIntValue((String)map.get("MaxResults"));
                this.maxScanRows = this.parseGroupIntValue((String)map.get("MaxScanRows"));
                this.timeout = this.parseGroupIntValue((String)map.get("Timeout"));
                String key = "Users";
                int i = 0;
                while (map.containsKey(key + i)) {
                    if (this.users == null) {
                        this.users = new ArrayList<String>();
                    }
                    this.users.add((String)map.get(key + i));
                    ++i;
                }
                key = "Owners";
                i = 0;
                while (map.containsKey(key + i)) {
                    if (this.owners == null) {
                        this.owners = new ArrayList<String>();
                    }
                    this.owners.add((String)map.get(key + i));
                    ++i;
                }
                key = "Subgroups";
                i = 0;
                while (map.containsKey(key + i)) {
                    if (this.subgroups == null) {
                        this.subgroups = new ArrayList<String>();
                    }
                    this.subgroups.add((String)map.get(key + i));
                    ++i;
                }
            }
            catch (Throwable thr) {
                P4JLog.warn("Unexpected exception in P4JUserGroupImpl constructor: " + thr.getMessage());
                P4JLog.exception(thr);
            }
        }
    }

    @Override
    public int getMaxLockTime() {
        return this.maxLockTime;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public int getMaxScanRows() {
        return this.maxScanRows;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getOwners() {
        return this.owners;
    }

    @Override
    public List<String> getSubgroups() {
        return this.subgroups;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public boolean isSubGroup() {
        return this.subGroup;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setMaxScanRows(int maxScanRows) {
        this.maxScanRows = maxScanRows;
    }

    public void setMaxLockTime(int maxLockTime) {
        this.maxLockTime = maxLockTime;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setSubgroups(List<String> subgroups) {
        this.subgroups = subgroups;
    }

    public void setOwners(List<String> owners) {
        this.owners = owners;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public void setSubGroup(boolean subGroup) {
        this.subGroup = subGroup;
    }

    public int parseGroupIntValue(String str) {
        if (str != null) {
            if (str.equalsIgnoreCase(UNSET_STR)) {
                return 0;
            }
            if (str.equalsIgnoreCase(UNLIMITED_STR)) {
                return -1;
            }
            return new Integer(str);
        }
        return 0;
    }
}

