/*
 * Decompiled with CFR 0.152.
 */
package com.example.uiwrapper;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.example.uiwrapper.StateManager;
import com.pecpwee.lib.envmock.EnvMockInstaller;
import com.pecpwee.lib.envmock.PlayConfig;
import com.pecpwee.lib.envmock.utils.LogUtils;

public class EnvMockUI {
    private static final String TAG = "EnvMockUI ";
    private static StateManager sController;

    private static void initCoreLib(Context context) {
        PlayConfig playConfig = new PlayConfig.Builder(context).setAutoPlayMode(false).setAutoStopMode(false).setDebugEnable(false).build();
        EnvMockInstaller.installPlayService((PlayConfig)playConfig);
    }

    public static void install(Application application, Context context) {
        EnvMockUI.initCoreLib(context);
        sController = new StateManager();
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
                LogUtils.d((String)("EnvMockUI onActivityStarted " + activity.getClass().getSimpleName()));
            }

            public void onActivityResumed(Activity activity) {
                LogUtils.d((String)("EnvMockUI onActivityResumed " + activity.getClass().getSimpleName()));
                sController.addFloatingWindow(activity);
            }

            public void onActivityPaused(Activity activity) {
                LogUtils.d((String)("EnvMockUI onActivityPaused " + activity.getClass().getSimpleName()));
                sController.removeFloatingWindow(activity);
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
    }
}

