/*
 * Decompiled with CFR 0.152.
 */
package com.example.uiwrapper;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageView;

public class FloatView
extends ImageView {
    private float mLastX;
    private float mLastY;
    private Boolean mIsDrag;
    private int mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop() << 1;

    public FloatView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setAlpha(0.8f);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mIsDrag = null;
                this.mLastX = event.getRawX();
                this.mLastY = event.getRawY();
                this.setAlpha(0.4f);
                break;
            }
            case 2: {
                float curX = event.getRawX();
                float curY = event.getRawY();
                if (this.mIsDrag == null) {
                    if (!(Math.pow(curX - this.mLastX, 2.0) + Math.pow(curY - this.mLastY, 2.0) > (double)this.mTouchSlop)) break;
                    this.mIsDrag = true;
                    this.mLastX = curX;
                    this.mLastY = curY;
                    break;
                }
                if (!this.mIsDrag.booleanValue()) break;
                ViewGroup.LayoutParams params = this.getLayoutParams();
                if (!(params instanceof ViewGroup.MarginLayoutParams)) {
                    return super.onTouchEvent(event);
                }
                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)params;
                marginLayoutParams.leftMargin = (int)((float)marginLayoutParams.leftMargin + (curX - this.mLastX));
                marginLayoutParams.topMargin = (int)((float)marginLayoutParams.topMargin + (curY - this.mLastY));
                this.requestLayout();
                this.mLastX = curX;
                this.mLastY = curY;
                break;
            }
            case 1: 
            case 3: {
                if (this.mIsDrag == null) {
                    this.performClick();
                }
                this.moveIfNeeded();
                this.setAlpha(0.8f);
            }
        }
        return true;
    }

    private void moveIfNeeded() {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        if (!(params instanceof ViewGroup.MarginLayoutParams)) {
            return;
        }
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)params;
        if (marginLayoutParams.leftMargin < 0) {
            marginLayoutParams.leftMargin = 0;
        }
        if (marginLayoutParams.topMargin < 0) {
            marginLayoutParams.topMargin = 0;
        }
        if (marginLayoutParams.leftMargin + this.getWidth() > ((View)this.getParent()).getWidth()) {
            marginLayoutParams.leftMargin = ((View)this.getParent()).getWidth() - this.getWidth();
        }
        if (marginLayoutParams.topMargin + this.getHeight() > ((View)this.getParent()).getHeight()) {
            marginLayoutParams.topMargin = ((View)this.getParent()).getHeight() - this.getHeight();
        }
        this.requestLayout();
    }
}

