/*
 * Decompiled with CFR 0.152.
 */
package com.example.uiwrapper;

import android.content.Context;
import android.location.Location;
import com.amap.api.maps.CoordinateConverter;
import com.amap.api.maps.model.LatLng;
import com.pecpwee.lib.envmock.PlayController;
import com.pecpwee.lib.envmock.utils.LogUtils;
import java.util.ArrayList;
import java.util.List;

public class MainPannelRepository {
    private CoordinateConverter coordinateConverter;

    public MainPannelRepository(Context context) {
        this.coordinateConverter = new CoordinateConverter(context.getApplicationContext());
        this.coordinateConverter.from(CoordinateConverter.CoordType.GPS);
    }

    public LatLng convert2AmapLoc(Location rawLocation) {
        LatLng latLng = new LatLng(rawLocation.getLatitude(), rawLocation.getLongitude());
        return this.coordinateConverter.coord(latLng).convert();
    }

    public List<LatLng> getPathList() {
        List locationList = PlayController.getInstance().getCompletePlayPathLocations();
        LogUtils.d((String)("getPathList" + locationList.size()));
        ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
        for (Location location : locationList) {
            latLngs.add(this.convert2AmapLoc(location));
        }
        return latLngs;
    }
}

