package com.paystack.android.ui.paymentsheet

import androidx.activity.ComponentActivity
import androidx.activity.result.ActivityResultLauncher
import androidx.activity.result.ActivityResultRegistry
import androidx.fragment.app.Fragment
import org.jetbrains.annotations.TestOnly

/**
 * This is used internally for integrations that don't use Jetpack Compose and are
 * able to pass in an activity.
 */
internal class DefaultPaymentSheetLauncher(
    private val activityResultLauncher: ActivityResultLauncher<PaymentSheetResultContract.Args>,
) : PaymentSheetLauncher {
    constructor(
        activity: ComponentActivity,
        callback: PaymentSheetResultCallback
    ) : this(
        activity.registerForActivityResult(PaymentSheetResultContract()) {
            callback.onPaymentResult(it)
        }
    )

    constructor(
        fragment: Fragment,
        callback: PaymentSheetResultCallback
    ) : this(
        fragment.registerForActivityResult(PaymentSheetResultContract()) {
            callback.onPaymentResult(it)
        }
    )

    @TestOnly
    constructor(
        fragment: Fragment,
        registry: ActivityResultRegistry,
        callback: PaymentSheetResultCallback
    ) : this(
        fragment.registerForActivityResult(
            PaymentSheetResultContract(),
            registry
        ) {
            callback.onPaymentResult(it)
        }
    )

    override fun launch(accessCode: String) {
        activityResultLauncher.launch(PaymentSheetResultContract.Args(accessCode))
    }
}
