package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa

internal sealed class MpesaPaymentState {
    object EnterNumber : MpesaPaymentState()
    data class InProgress(
        val instruction: String,
        val phoneNumber: String,
        val requeryDelayMs: Int,
        val timeLeftMs: Int
    ) : MpesaPaymentState()

    object VerifyingPayment : MpesaPaymentState()

    data class Error(val message: String) : MpesaPaymentState()
}
