/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.ui.utilities;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/paystack/android/ui/utilities/CurrencyFormatter;", "", "()V", "MAX_FRACTION_DIGITS", "", "format", "", "amount", "", "currencyCode", "showEmptyFractions", "", "showCommaSeparators", "getMinimumDecimalDigits", "Ljava/math/BigDecimal;", "moneyFormat", "paystack-ui_release"})
public final class CurrencyFormatter {
    @NotNull
    public static final CurrencyFormatter INSTANCE = new CurrencyFormatter();
    private static final int MAX_FRACTION_DIGITS = 2;

    private CurrencyFormatter() {
    }

    @NotNull
    public final String format(long amount, @NotNull String currencyCode, boolean showEmptyFractions, boolean showCommaSeparators) {
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        String formattedAmount = this.moneyFormat(amount, showEmptyFractions, showCommaSeparators);
        return currencyCode + " " + formattedAmount;
    }

    public static /* synthetic */ String format$default(CurrencyFormatter currencyFormatter, long l, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return currencyFormatter.format(l, string2, bl, bl2);
    }

    private final String moneyFormat(long amount, boolean showEmptyFractions, boolean showCommaSeparators) {
        int n;
        BigDecimal value = new BigDecimal(amount).abs().divide(new BigDecimal("100")).setScale(2);
        String formatPattern = showCommaSeparators ? "###,###.##" : "######.##";
        DecimalFormat formatter = new DecimalFormat(formatPattern);
        if (showEmptyFractions) {
            n = 2;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            n = this.getMinimumDecimalDigits(value);
        }
        formatter.setMinimumFractionDigits(n);
        formatter.setMaximumFractionDigits(2);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setGroupingSeparator(',');
        formatter.setDecimalFormatSymbols(symbols);
        String string2 = formatter.format(value.doubleValue());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatter.format(value.toDouble())");
        return string2;
    }

    static /* synthetic */ String moneyFormat$default(CurrencyFormatter currencyFormatter, long l, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return currencyFormatter.moneyFormat(l, bl, bl2);
    }

    private final int getMinimumDecimalDigits(BigDecimal amount) {
        BigDecimal remainder = amount.remainder(BigDecimal.ONE);
        return remainder.compareTo(BigDecimal.ZERO) > 0 ? 2 : 0;
    }
}

