package com.paystack.android.ui.components.buttons

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.interaction.MutableInteractionSource
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.RowScope
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.ButtonColors
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.ButtonElevation
import androidx.compose.material3.OutlinedButton
import androidx.compose.material3.ProvideTextStyle
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.paystack.android.ui.theme.PaystackTheme
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
internal fun SecondaryButton(
    text: String,
    onClick: () -> Unit,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
) {
    SecondaryButton(
        onClick = onClick,
        modifier = modifier,
        enabled = enabled,
    ) {
        ProvideTextStyle(value = PaystackTheme.typography.body.body16M) {
            Text(text = text)
        }
    }
}

@Composable
internal fun SecondaryButton(
    onClick: () -> Unit,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    shape: Shape = RoundedCornerShape(PaystackTheme.dimensions.borderRadius.large),
    colors: ButtonColors = ButtonDefaults.outlinedButtonColors(
        contentColor = PaystackTheme.colors.secondaryColors.green02
    ),
    elevation: ButtonElevation? = null,
    border: BorderStroke? = BorderStroke(1.dp, PaystackTheme.colors.secondaryColors.green02),
    contentPadding: PaddingValues = PaddingValues(
        horizontal = PaystackTheme.dimensions.spacing.double,
        vertical = PaystackTheme.dimensions.spacing.triple
    ),
    interactionSource: MutableInteractionSource = remember { MutableInteractionSource() },
    content: @Composable RowScope.() -> Unit
) {
    OutlinedButton(
        onClick = onClick,
        modifier = modifier,
        enabled = enabled,
        shape = shape,
        colors = colors,
        elevation = elevation,
        border = border,
        contentPadding = contentPadding,
        interactionSource = interactionSource,
        content = content
    )
}

@Composable
@Preview
internal fun SecondaryButtonPreview() {
    PaystackTheme {
        Surface(modifier = Modifier.fillMaxSize()) {
            Box(contentAlignment = Alignment.Center) {
                SecondaryButton(onClick = {}) {
                    Text(text = "Try another card")
                }
            }
        }
    }
}
