package com.paystack.android_sdk.ui

import android.os.Parcelable
import com.paystack.android_sdk.core.api.models.AccessCodeData
import com.paystack.android_sdk.core.api.models.PaymentChannel
import com.paystack.android_sdk.core.api.models.PaystackError
import com.paystack.android_sdk.ui.models.Charge
import com.paystack.android_sdk.ui.utilities.isFatal
import kotlinx.parcelize.Parcelize

/**
 * The state of the payments process. This is driven by responses from Paystack's API
 * The different states here should hold the data needed to display its UI.
 */
internal sealed class PaymentUiState : Parcelable {
    @Parcelize
    object Initialization : PaymentUiState()

    @Parcelize
    data class PaymentProcess(
        val selectedPaymentChannel: PaymentChannel,
        val accessCodeData: AccessCodeData,
    ) : PaymentUiState()

    @Parcelize
    data class Success(
        val charge: Charge,
        val merchantName: String,
    ) : PaymentUiState() {
        override val isTerminal: Boolean
            get() = true
    }

    @Parcelize
    data class Error(val displayText: String, val error: Throwable) : PaymentUiState() {
        constructor(error: Throwable) : this(error.message.orEmpty(), error)

        override val isTerminal: Boolean
            get() = if (error is PaystackError) error.isFatal else true
    }

    open val isTerminal: Boolean
        get() = false
}
