/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android_sdk.ui;

import android.os.Bundle;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.savedstate.SavedStateRegistryOwner;
import com.paystack.android_sdk.core.api.models.AccessCodeData;
import com.paystack.android_sdk.core.logging.Logger;
import com.paystack.android_sdk.ui.PaymentUiState;
import com.paystack.android_sdk.ui.R;
import com.paystack.android_sdk.ui.data.transaction.TransactionRepository;
import com.paystack.android_sdk.ui.models.Charge;
import com.paystack.android_sdk.ui.utilities.StringProvider;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\rH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/paystack/android_sdk/ui/PaymentsViewModel;", "Landroidx/lifecycle/ViewModel;", "transactionRepository", "Lcom/paystack/android_sdk/ui/data/transaction/TransactionRepository;", "stringProvider", "Lcom/paystack/android_sdk/ui/utilities/StringProvider;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Lcom/paystack/android_sdk/ui/data/transaction/TransactionRepository;Lcom/paystack/android_sdk/ui/utilities/StringProvider;Landroidx/lifecycle/SavedStateHandle;)V", "_paymentUiState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/paystack/android_sdk/ui/PaymentUiState;", "_transactionAccessData", "Lcom/paystack/android_sdk/core/api/models/AccessCodeData;", "paymentUiState", "Lkotlinx/coroutines/flow/StateFlow;", "getPaymentUiState", "()Lkotlinx/coroutines/flow/StateFlow;", "transactionAccessData", "getTransactionAccessData", "loadTransaction", "", "accessCode", "", "onTransactionComplete", "charge", "Lcom/paystack/android_sdk/ui/models/Charge;", "startPaymentProcess", "accessCodeData", "Factory", "paystack-ui_release"})
@SourceDebugExtension(value={"SMAP\nPaymentsViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentsViewModel.kt\ncom/paystack/android_sdk/ui/PaymentsViewModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,95:1\n230#2,5:96\n*S KotlinDebug\n*F\n+ 1 PaymentsViewModel.kt\ncom/paystack/android_sdk/ui/PaymentsViewModel\n*L\n37#1:96,5\n*E\n"})
public final class PaymentsViewModel
extends ViewModel {
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final StringProvider stringProvider;
    @NotNull
    private final MutableStateFlow<PaymentUiState> _paymentUiState;
    @NotNull
    private final MutableStateFlow<AccessCodeData> _transactionAccessData;

    public PaymentsViewModel(@NotNull TransactionRepository transactionRepository, @NotNull StringProvider stringProvider, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)stringProvider, (String)"stringProvider");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.transactionRepository = transactionRepository;
        this.stringProvider = stringProvider;
        this._paymentUiState = StateFlowKt.MutableStateFlow((Object)PaymentUiState.Initialization.INSTANCE);
        this._transactionAccessData = StateFlowKt.MutableStateFlow(null);
        String accessCode = (String)savedStateHandle.get("transaction_access_code");
        if (accessCode == null) {
            IllegalStateException error;
            PaymentUiState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<PaymentUiState> $this$update$iv = this._paymentUiState;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                PaymentUiState it = (PaymentUiState)prevValue$iv;
                boolean bl = false;
                error = new IllegalStateException("No transaction access code provided");
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (PaymentUiState)new PaymentUiState.Error(this.stringProvider.getString(R.string.could_not_start_transaction), error))));
        } else {
            this.loadTransaction(accessCode);
        }
    }

    @NotNull
    public final StateFlow<PaymentUiState> getPaymentUiState() {
        return (StateFlow)this._paymentUiState;
    }

    @NotNull
    public final StateFlow<AccessCodeData> getTransactionAccessData() {
        return (StateFlow)this._transactionAccessData;
    }

    private final void loadTransaction(String accessCode) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, accessCode, null){
            int label;
            final /* synthetic */ PaymentsViewModel this$0;
            final /* synthetic */ String $accessCode;
            {
                this.this$0 = $receiver;
                this.$accessCode = $accessCode;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = PaymentsViewModel.access$getTransactionRepository$p(this.this$0).getByAccessCode-gIAlu-s(this.$accessCode, (Continuation<? super Result<AccessCodeData>>)((Continuation)this));
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = ((Result)$result).unbox-impl();
lbl13:
                        // 2 sources

                        var2_3 = v0;
                        var3_4 = this.this$0;
                        if (Result.isSuccess-impl((Object)var2_3)) {
                            it = (AccessCodeData)var2_3;
                            $i$a$-onSuccess-PaymentsViewModel$loadTransaction$1$1 = false;
                            PaymentsViewModel.access$get_transactionAccessData$p(var3_4).setValue((Object)it);
                            PaymentsViewModel.access$startPaymentProcess(var3_4, it);
                        }
                        var3_4 = this.this$0;
                        v1 = Result.exceptionOrNull-impl((Object)var2_3);
                        if (v1 != null) {
                            error = var4_5 = v1;
                            $i$a$-onFailure-PaymentsViewModel$loadTransaction$1$2 = false;
                            v2 = error.getMessage();
                            if (v2 == null) {
                                v2 = "";
                            }
                            Logger.INSTANCE.error(v2, error);
                            PaymentsViewModel.access$get_paymentUiState$p(var3_4).setValue((Object)new PaymentUiState.Error(error));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void startPaymentProcess(AccessCodeData accessCodeData) {
        this._paymentUiState.setValue((Object)new PaymentUiState.PaymentProcess("card", accessCodeData));
    }

    public final void onTransactionComplete(@NotNull Charge charge) {
        Intrinsics.checkNotNullParameter((Object)charge, (String)"charge");
        AccessCodeData accessCodeData = (AccessCodeData)this.getTransactionAccessData().getValue();
        String string2 = accessCodeData != null ? accessCodeData.getMerchantName() : null;
        if (string2 == null) {
            string2 = "";
        }
        this._paymentUiState.setValue((Object)new PaymentUiState.Success(charge, string2));
    }

    public static final /* synthetic */ TransactionRepository access$getTransactionRepository$p(PaymentsViewModel $this) {
        return $this.transactionRepository;
    }

    public static final /* synthetic */ MutableStateFlow access$get_transactionAccessData$p(PaymentsViewModel $this) {
        return $this._transactionAccessData;
    }

    public static final /* synthetic */ void access$startPaymentProcess(PaymentsViewModel $this, AccessCodeData accessCodeData) {
        $this.startPaymentProcess(accessCodeData);
    }

    public static final /* synthetic */ MutableStateFlow access$get_paymentUiState$p(PaymentsViewModel $this) {
        return $this._paymentUiState;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ5\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/paystack/android_sdk/ui/PaymentsViewModel$Factory;", "Landroidx/lifecycle/AbstractSavedStateViewModelFactory;", "transactionRepository", "Lcom/paystack/android_sdk/ui/data/transaction/TransactionRepository;", "stringProvider", "Lcom/paystack/android_sdk/ui/utilities/StringProvider;", "savedStateRegistryOwner", "Landroidx/savedstate/SavedStateRegistryOwner;", "defaultArgs", "Landroid/os/Bundle;", "(Lcom/paystack/android_sdk/ui/data/transaction/TransactionRepository;Lcom/paystack/android_sdk/ui/utilities/StringProvider;Landroidx/savedstate/SavedStateRegistryOwner;Landroid/os/Bundle;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "key", "", "modelClass", "Ljava/lang/Class;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "(Ljava/lang/String;Ljava/lang/Class;Landroidx/lifecycle/SavedStateHandle;)Landroidx/lifecycle/ViewModel;", "paystack-ui_release"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    extends AbstractSavedStateViewModelFactory {
        @NotNull
        private final TransactionRepository transactionRepository;
        @NotNull
        private final StringProvider stringProvider;
        public static final int $stable;

        public Factory(@NotNull TransactionRepository transactionRepository, @NotNull StringProvider stringProvider, @NotNull SavedStateRegistryOwner savedStateRegistryOwner, @Nullable Bundle defaultArgs) {
            Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
            Intrinsics.checkNotNullParameter((Object)stringProvider, (String)"stringProvider");
            Intrinsics.checkNotNullParameter((Object)savedStateRegistryOwner, (String)"savedStateRegistryOwner");
            super(savedStateRegistryOwner, defaultArgs);
            this.transactionRepository = transactionRepository;
            this.stringProvider = stringProvider;
        }

        public /* synthetic */ Factory(TransactionRepository transactionRepository, StringProvider stringProvider, SavedStateRegistryOwner savedStateRegistryOwner, Bundle bundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bundle = null;
            }
            this(transactionRepository, stringProvider, savedStateRegistryOwner, bundle);
        }

        @NotNull
        protected <T extends ViewModel> T create(@NotNull String key, @NotNull Class<T> modelClass, @NotNull SavedStateHandle handle) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            if (modelClass.isAssignableFrom(PaymentsViewModel.class)) {
                return (T)((Object)new PaymentsViewModel(this.transactionRepository, this.stringProvider, handle));
            }
            throw new IllegalArgumentException("Unknown ViewModel class");
        }
    }
}

