@file:Suppress("LongParameterList")
package com.paystack.android.ui.theme.colors

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.ui.graphics.Color

internal class SecondaryColors(
    stackGreen: Color,
    green01: Color,
    green02: Color,
    green03: Color,
    green04: Color,
    green05: Color
) {
    var stackGreen by mutableStateOf(stackGreen)
        private set
    var green01 by mutableStateOf(green01)
        private set
    var green02 by mutableStateOf(green02)
        private set
    var green03 by mutableStateOf(green03)
        private set
    var green04 by mutableStateOf(green04)
        private set
    var green05 by mutableStateOf(green05)
        private set

    fun copy(
        stackGreen: Color = this.stackGreen,
        green01: Color = this.green01,
        green02: Color = this.green02,
        green03: Color = this.green03,
        green04: Color = this.green04,
        green05: Color = this.green05
    ): SecondaryColors = SecondaryColors(
        stackGreen,
        green01,
        green02,
        green03,
        green04,
        green05
    )

    fun updateColorsFrom(other: SecondaryColors) {
        stackGreen = other.stackGreen
        green01 = other.green01
        green02 = other.green02
        green03 = other.green03
        green04 = other.green04
        green05 = other.green05
    }
}

private val stackGreenDefault = Color(0xFF3BB75E)
private val Green01 = Color(0xFF005017)
private val Green02 = Color(0xFF1D853A)
private val Green03 = Color(0xFF89D49E)
private val Green04 = Color(0xFFCDF4D7)
private val Green05 = Color(0xFFF3FBF4)

internal fun lightSecondaryColors(
    stackGreen: Color = stackGreenDefault,
    green01: Color = Green01,
    green02: Color = Green02,
    green03: Color = Green03,
    green04: Color = Green04,
    green05: Color = Green05
): SecondaryColors = SecondaryColors(
    stackGreen,
    green01,
    green02,
    green03,
    green04,
    green05
)
