package com.paystack.android.ui.components.views.text

import androidx.compose.material3.LocalContentColor
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import com.paystack.android.ui.theme.PaystackTheme
import java.text.DecimalFormat
import java.text.NumberFormat

@Composable
@Suppress("MagicNumber")
internal fun CountdownText(
    timeMillis: Long,
    prefix: String,
    timerColor: Color = PaystackTheme.colors.secondaryColors.stackGreen,
    prefixColor: Color = LocalContentColor.current,
) {
    val formatter: NumberFormat = DecimalFormat("00")
    val min = formatter.format(timeMillis / 60000 % 60)
    val sec = formatter.format(timeMillis / 1000 % 60)

    val annotatedString = buildAnnotatedString {
        withStyle(style = SpanStyle(color = prefixColor)) {
            append(prefix)
        }
        withStyle(style = SpanStyle(color = timerColor)) {
            append(" $min:$sec")
        }
    }
    Text(text = annotatedString)
}
