package com.paystack.androiddesignsystem.typography

import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.Font
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.sp
import com.paystack.androiddesignsystem.R

private val graphikFontFamily = FontFamily(
    Font(R.font.graphik_medium, FontWeight.Medium)
)

data class ButtonTypography(

    /**
     * For Primary buttons
     */
    val buttonPrimary: TextStyle = TextStyle(
        fontFamily = graphikFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 14.sp,
        lineHeight = 21.sp
    )
)
