/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.BillingAgreementToken;
import com.paypal.api.payments.CreditFinancingOffered;
import com.paypal.api.payments.Error;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.Patch;
import com.paypal.api.payments.Payee;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.PaymentExecution;
import com.paypal.api.payments.PaymentHistory;
import com.paypal.api.payments.PaymentInstruction;
import com.paypal.api.payments.PotentialPayerInfo;
import com.paypal.api.payments.RedirectUrls;
import com.paypal.api.payments.Transaction;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.JSONFormatter;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.List;
import java.util.Map;

public class Payment
extends PayPalResource {
    private String id;
    private String intent;
    private Payer payer;
    private PotentialPayerInfo potentialPayerInfo;
    private Payee payee;
    private String cart;
    private List<Transaction> transactions;
    private List<Error> failedTransactions;
    private List<BillingAgreementToken> billingAgreementTokens;
    private CreditFinancingOffered creditFinancingOffered;
    private PaymentInstruction paymentInstruction;
    private String state;
    private String experienceProfileId;
    private String noteToPayer;
    private RedirectUrls redirectUrls;
    private String failureReason;
    private String createTime;
    private String updateTime;
    private List<Links> links;

    public Payment() {
    }

    public Payment(String intent, Payer payer) {
        this.intent = intent;
        this.payer = payer;
    }

    public Payment create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public Payment create(APIContext apiContext) throws PayPalRESTException {
        apiContext.setRequestId(null);
        String resourcePath = "v1/payments/payment";
        String payLoad = this.toJSON();
        Payment payment = Payment.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Payment.class);
        apiContext.setRequestId(null);
        return payment;
    }

    public static Payment get(String accessToken, String paymentId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Payment.get(apiContext, paymentId);
    }

    public static Payment get(APIContext apiContext, String paymentId) throws PayPalRESTException {
        if (paymentId == null) {
            throw new IllegalArgumentException("paymentId cannot be null");
        }
        Object[] parameters = new Object[]{paymentId};
        String pattern = "v1/payments/payment/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Payment.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Payment.class);
    }

    public Payment execute(String accessToken, PaymentExecution paymentExecution) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.execute(apiContext, paymentExecution);
    }

    public Payment execute(APIContext apiContext, PaymentExecution paymentExecution) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (paymentExecution == null) {
            throw new IllegalArgumentException("paymentExecution cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/payment/{0}/execute";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = paymentExecution.toJSON();
        return Payment.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Payment.class);
    }

    public void update(String accessToken, List<Patch> patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.update(apiContext, patchRequest);
    }

    public void update(APIContext apiContext, List<Patch> patchRequest) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/payment/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = JSONFormatter.toJSON(patchRequest);
        PayPalResource.configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, null);
    }

    public static PaymentHistory list(String accessToken, Map<String, String> containerMap) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Payment.list(apiContext, containerMap);
    }

    public static PaymentHistory list(APIContext apiContext, Map<String, String> containerMap) throws PayPalRESTException {
        if (containerMap == null) {
            throw new IllegalArgumentException("containerMap cannot be null");
        }
        apiContext.setRequestId(null);
        Object[] parameters = new Object[]{containerMap};
        String pattern = "v1/payments/payment?count={0}&start_id={1}&start_index={2}&start_time={3}&end_time={4}&payee_id={5}&sort_by={6}&sort_order={7}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        PaymentHistory paymentHistory = Payment.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, PaymentHistory.class);
        apiContext.setRequestId(null);
        return paymentHistory;
    }

    public String getId() {
        return this.id;
    }

    public String getIntent() {
        return this.intent;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public PotentialPayerInfo getPotentialPayerInfo() {
        return this.potentialPayerInfo;
    }

    public Payee getPayee() {
        return this.payee;
    }

    public String getCart() {
        return this.cart;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public List<Error> getFailedTransactions() {
        return this.failedTransactions;
    }

    public List<BillingAgreementToken> getBillingAgreementTokens() {
        return this.billingAgreementTokens;
    }

    public CreditFinancingOffered getCreditFinancingOffered() {
        return this.creditFinancingOffered;
    }

    public PaymentInstruction getPaymentInstruction() {
        return this.paymentInstruction;
    }

    public String getState() {
        return this.state;
    }

    public String getExperienceProfileId() {
        return this.experienceProfileId;
    }

    public String getNoteToPayer() {
        return this.noteToPayer;
    }

    public RedirectUrls getRedirectUrls() {
        return this.redirectUrls;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Payment setId(String id) {
        this.id = id;
        return this;
    }

    public Payment setIntent(String intent) {
        this.intent = intent;
        return this;
    }

    public Payment setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public Payment setPotentialPayerInfo(PotentialPayerInfo potentialPayerInfo) {
        this.potentialPayerInfo = potentialPayerInfo;
        return this;
    }

    public Payment setPayee(Payee payee) {
        this.payee = payee;
        return this;
    }

    public Payment setCart(String cart) {
        this.cart = cart;
        return this;
    }

    public Payment setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public Payment setFailedTransactions(List<Error> failedTransactions) {
        this.failedTransactions = failedTransactions;
        return this;
    }

    public Payment setBillingAgreementTokens(List<BillingAgreementToken> billingAgreementTokens) {
        this.billingAgreementTokens = billingAgreementTokens;
        return this;
    }

    public Payment setCreditFinancingOffered(CreditFinancingOffered creditFinancingOffered) {
        this.creditFinancingOffered = creditFinancingOffered;
        return this;
    }

    public Payment setPaymentInstruction(PaymentInstruction paymentInstruction) {
        this.paymentInstruction = paymentInstruction;
        return this;
    }

    public Payment setState(String state) {
        this.state = state;
        return this;
    }

    public Payment setExperienceProfileId(String experienceProfileId) {
        this.experienceProfileId = experienceProfileId;
        return this;
    }

    public Payment setNoteToPayer(String noteToPayer) {
        this.noteToPayer = noteToPayer;
        return this;
    }

    public Payment setRedirectUrls(RedirectUrls redirectUrls) {
        this.redirectUrls = redirectUrls;
        return this;
    }

    public Payment setFailureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    public Payment setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public Payment setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public Payment setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payment)) {
            return false;
        }
        Payment other = (Payment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$intent = this.getIntent();
        String other$intent = other.getIntent();
        if (this$intent == null ? other$intent != null : !this$intent.equals(other$intent)) {
            return false;
        }
        Payer this$payer = this.getPayer();
        Payer other$payer = other.getPayer();
        if (this$payer == null ? other$payer != null : !((Object)this$payer).equals(other$payer)) {
            return false;
        }
        PotentialPayerInfo this$potentialPayerInfo = this.getPotentialPayerInfo();
        PotentialPayerInfo other$potentialPayerInfo = other.getPotentialPayerInfo();
        if (this$potentialPayerInfo == null ? other$potentialPayerInfo != null : !((Object)this$potentialPayerInfo).equals(other$potentialPayerInfo)) {
            return false;
        }
        Payee this$payee = this.getPayee();
        Payee other$payee = other.getPayee();
        if (this$payee == null ? other$payee != null : !((Object)this$payee).equals(other$payee)) {
            return false;
        }
        String this$cart = this.getCart();
        String other$cart = other.getCart();
        if (this$cart == null ? other$cart != null : !this$cart.equals(other$cart)) {
            return false;
        }
        List<Transaction> this$transactions = this.getTransactions();
        List<Transaction> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        List<Error> this$failedTransactions = this.getFailedTransactions();
        List<Error> other$failedTransactions = other.getFailedTransactions();
        if (this$failedTransactions == null ? other$failedTransactions != null : !((Object)this$failedTransactions).equals(other$failedTransactions)) {
            return false;
        }
        List<BillingAgreementToken> this$billingAgreementTokens = this.getBillingAgreementTokens();
        List<BillingAgreementToken> other$billingAgreementTokens = other.getBillingAgreementTokens();
        if (this$billingAgreementTokens == null ? other$billingAgreementTokens != null : !((Object)this$billingAgreementTokens).equals(other$billingAgreementTokens)) {
            return false;
        }
        CreditFinancingOffered this$creditFinancingOffered = this.getCreditFinancingOffered();
        CreditFinancingOffered other$creditFinancingOffered = other.getCreditFinancingOffered();
        if (this$creditFinancingOffered == null ? other$creditFinancingOffered != null : !((Object)this$creditFinancingOffered).equals(other$creditFinancingOffered)) {
            return false;
        }
        PaymentInstruction this$paymentInstruction = this.getPaymentInstruction();
        PaymentInstruction other$paymentInstruction = other.getPaymentInstruction();
        if (this$paymentInstruction == null ? other$paymentInstruction != null : !((Object)this$paymentInstruction).equals(other$paymentInstruction)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$experienceProfileId = this.getExperienceProfileId();
        String other$experienceProfileId = other.getExperienceProfileId();
        if (this$experienceProfileId == null ? other$experienceProfileId != null : !this$experienceProfileId.equals(other$experienceProfileId)) {
            return false;
        }
        String this$noteToPayer = this.getNoteToPayer();
        String other$noteToPayer = other.getNoteToPayer();
        if (this$noteToPayer == null ? other$noteToPayer != null : !this$noteToPayer.equals(other$noteToPayer)) {
            return false;
        }
        RedirectUrls this$redirectUrls = this.getRedirectUrls();
        RedirectUrls other$redirectUrls = other.getRedirectUrls();
        if (this$redirectUrls == null ? other$redirectUrls != null : !((Object)this$redirectUrls).equals(other$redirectUrls)) {
            return false;
        }
        String this$failureReason = this.getFailureReason();
        String other$failureReason = other.getFailureReason();
        if (this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Payment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $intent = this.getIntent();
        result = result * 59 + ($intent == null ? 43 : $intent.hashCode());
        Payer $payer = this.getPayer();
        result = result * 59 + ($payer == null ? 43 : ((Object)$payer).hashCode());
        PotentialPayerInfo $potentialPayerInfo = this.getPotentialPayerInfo();
        result = result * 59 + ($potentialPayerInfo == null ? 43 : ((Object)$potentialPayerInfo).hashCode());
        Payee $payee = this.getPayee();
        result = result * 59 + ($payee == null ? 43 : ((Object)$payee).hashCode());
        String $cart = this.getCart();
        result = result * 59 + ($cart == null ? 43 : $cart.hashCode());
        List<Transaction> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        List<Error> $failedTransactions = this.getFailedTransactions();
        result = result * 59 + ($failedTransactions == null ? 43 : ((Object)$failedTransactions).hashCode());
        List<BillingAgreementToken> $billingAgreementTokens = this.getBillingAgreementTokens();
        result = result * 59 + ($billingAgreementTokens == null ? 43 : ((Object)$billingAgreementTokens).hashCode());
        CreditFinancingOffered $creditFinancingOffered = this.getCreditFinancingOffered();
        result = result * 59 + ($creditFinancingOffered == null ? 43 : ((Object)$creditFinancingOffered).hashCode());
        PaymentInstruction $paymentInstruction = this.getPaymentInstruction();
        result = result * 59 + ($paymentInstruction == null ? 43 : ((Object)$paymentInstruction).hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $experienceProfileId = this.getExperienceProfileId();
        result = result * 59 + ($experienceProfileId == null ? 43 : $experienceProfileId.hashCode());
        String $noteToPayer = this.getNoteToPayer();
        result = result * 59 + ($noteToPayer == null ? 43 : $noteToPayer.hashCode());
        RedirectUrls $redirectUrls = this.getRedirectUrls();
        result = result * 59 + ($redirectUrls == null ? 43 : ((Object)$redirectUrls).hashCode());
        String $failureReason = this.getFailureReason();
        result = result * 59 + ($failureReason == null ? 43 : $failureReason.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }
}

