/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base;

import com.paypal.base.APICallPreHandler;
import com.paypal.base.ConfigManager;
import com.paypal.base.ConnectionManager;
import com.paypal.base.HttpConfiguration;
import com.paypal.base.HttpConnection;
import com.paypal.base.credential.CertificateCredential;
import com.paypal.base.exception.ClientActionRequiredException;
import com.paypal.base.exception.HttpErrorException;
import com.paypal.base.exception.InvalidCredentialException;
import com.paypal.base.exception.InvalidResponseDataException;
import com.paypal.base.exception.MissingCredentialException;
import com.paypal.base.exception.OAuthException;
import com.paypal.base.exception.SSLConfigurationException;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIService {
    private static final Logger log = LoggerFactory.getLogger(APIService.class);
    private String endPoint;
    private Map<String, String> configurationMap = null;
    private ConfigManager config = null;
    private HttpConfiguration httpConfiguration = null;

    public APIService() {
        this.httpConfiguration = new HttpConfiguration();
        this.config = ConfigManager.getInstance();
        this.endPoint = this.config.getValue("service.EndPoint");
        this.httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(this.config.getValue("http.GoogleAppEngine")));
        if (Boolean.parseBoolean(this.config.getValue("http.UseProxy"))) {
            this.httpConfiguration.setProxyPort(Integer.parseInt(this.config.getValue("http.ProxyPort")));
            this.httpConfiguration.setProxyHost(this.config.getValue("http.ProxyHost"));
            this.httpConfiguration.setProxyUserName(this.config.getValue("http.ProxyUserName"));
            this.httpConfiguration.setProxyPassword(this.config.getValue("http.ProxyPassword"));
        }
        this.httpConfiguration.setConnectionTimeout(Integer.parseInt(this.config.getValue("http.ConnectionTimeOut")));
        this.httpConfiguration.setMaxRetry(Integer.parseInt(this.config.getValue("http.Retry")));
        this.httpConfiguration.setReadTimeout(Integer.parseInt(this.config.getValue("http.ReadTimeOut")));
        this.httpConfiguration.setMaxHttpConnection(Integer.parseInt(this.config.getValue("http.MaxConnection")));
        this.httpConfiguration.setIpAddress(this.config.getValue("http.IPAddress"));
    }

    public APIService(Map<String, String> configurationMap) {
        if (configurationMap == null) {
            throw new IllegalArgumentException("ConfigurationMap cannot be null");
        }
        this.configurationMap = configurationMap;
        this.httpConfiguration = new HttpConfiguration();
        this.endPoint = this.configurationMap.get("service.EndPoint");
        this.httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(this.configurationMap.get("http.GoogleAppEngine")));
        if (Boolean.parseBoolean(this.configurationMap.get("http.UseProxy"))) {
            this.httpConfiguration.setProxyPort(Integer.parseInt(this.configurationMap.get("http.ProxyPort")));
            this.httpConfiguration.setProxyHost(this.configurationMap.get("http.ProxyHost"));
            this.httpConfiguration.setProxyUserName(this.configurationMap.get("http.ProxyUserName"));
            this.httpConfiguration.setProxyPassword(this.configurationMap.get("http.ProxyPassword"));
        }
        this.httpConfiguration.setConnectionTimeout(Integer.parseInt(this.configurationMap.get("http.ConnectionTimeOut")));
        this.httpConfiguration.setMaxRetry(Integer.parseInt(this.configurationMap.get("http.Retry")));
        this.httpConfiguration.setReadTimeout(Integer.parseInt(this.configurationMap.get("http.ReadTimeOut")));
        this.httpConfiguration.setMaxHttpConnection(Integer.parseInt(this.configurationMap.get("http.MaxConnection")));
        this.httpConfiguration.setIpAddress(this.configurationMap.get("http.IPAddress"));
    }

    public String makeRequestUsing(APICallPreHandler apiCallPreHandler) throws InvalidResponseDataException, HttpErrorException, ClientActionRequiredException, IOException, InterruptedException, InvalidCredentialException, MissingCredentialException, OAuthException, SSLConfigurationException {
        String response = null;
        apiCallPreHandler.validate();
        Map<String, String> headers = null;
        ConnectionManager connectionMgr = ConnectionManager.getInstance();
        HttpConnection connection = connectionMgr.getConnection(this.httpConfiguration);
        String url = apiCallPreHandler.getEndPoint();
        if (url == null || url.trim().length() <= 0) {
            throw new HttpErrorException("Unable to retrieve a valid end-point from configuration");
        }
        this.httpConfiguration.setEndPointUrl(url);
        headers = apiCallPreHandler.getHeaderMap();
        String payLoad = apiCallPreHandler.getPayLoad();
        log.info(this.payLoadToLog(payLoad));
        if (apiCallPreHandler.getCredential() instanceof CertificateCredential) {
            CertificateCredential credential = (CertificateCredential)apiCallPreHandler.getCredential();
            connection.setupClientSSL(credential.getCertificatePath(), credential.getCertificateKey());
        }
        connection.createAndconfigureHttpConnection(this.httpConfiguration);
        if (this.httpConfiguration.getIpAddress() != null) {
            headers.put("X-PAYPAL-DEVICE-IPADDRESS", this.httpConfiguration.getIpAddress());
        }
        response = connection.execute(url, payLoad, headers);
        log.info(response);
        return response;
    }

    private String payLoadToLog(String payload) {
        Pattern p = Pattern.compile("(<(ebl:(Username|Password|Subject|Signature|CreditCardNumber|CVV2))>)[\\W\\w]+(</\\2>)");
        String passSub = p.matcher(payload).replaceAll("$1****************$4");
        return passSub;
    }

    public String getEndPoint() {
        return this.endPoint;
    }
}

