/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.google.gson.GsonBuilder;
import com.paypal.api.payments.Address;
import com.paypal.api.payments.CreditCardHistory;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.Patch;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreditCard
extends PayPalResource {
    private String id;
    private String number;
    private String type;
    private int expireMonth;
    private int expireYear;
    private Integer cvv2;
    private String firstName;
    private String lastName;
    private Address billingAddress;
    private String externalCustomerId;
    private String state;
    private String validUntil;
    private List<Links> links;
    private String payerId;

    public CreditCard() {
    }

    public CreditCard(String number, String type, int expireMonth, int expireYear) {
        this.number = number;
        this.type = type;
        this.expireMonth = expireMonth;
        this.expireYear = expireYear;
    }

    public CreditCard setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public CreditCard setNumber(String number) {
        this.number = number;
        return this;
    }

    public String getNumber() {
        return this.number;
    }

    public CreditCard setType(String type) {
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public CreditCard setExpireMonth(int expireMonth) {
        this.expireMonth = expireMonth;
        return this;
    }

    public int getExpireMonth() {
        return this.expireMonth;
    }

    public CreditCard setExpireYear(int expireYear) {
        this.expireYear = expireYear;
        return this;
    }

    public int getExpireYear() {
        return this.expireYear;
    }

    public CreditCard setCvv2(Integer cvv2) {
        this.cvv2 = cvv2;
        return this;
    }

    public int getCvv2() {
        if (this.cvv2 == null) {
            return -1;
        }
        return this.cvv2;
    }

    public CreditCard setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public CreditCard setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String getLastName() {
        return this.lastName;
    }

    public CreditCard setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public CreditCard setExternalCustomerId(String externalCustomerId) {
        this.externalCustomerId = externalCustomerId;
        return this;
    }

    public String getExternalCustomerId() {
        return this.externalCustomerId;
    }

    public CreditCard setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public CreditCard setValidUntil(String validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public String getValidUntil() {
        return this.validUntil;
    }

    public CreditCard setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public CreditCard setPayerId(String payerId) {
        this.payerId = payerId;
        return this;
    }

    public String getpayerId() {
        return this.payerId;
    }

    public CreditCard create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public CreditCard create(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        String resourcePath = "v1/vault/credit-cards";
        String payLoad = this.toJSON();
        return CreditCard.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, CreditCard.class);
    }

    public static CreditCard get(String accessToken, String creditCardId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return CreditCard.get(apiContext, creditCardId);
    }

    public static CreditCard get(APIContext apiContext, String creditCardId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (creditCardId == null) {
            throw new IllegalArgumentException("creditCardId cannot be null");
        }
        Object[] parameters = new Object[]{creditCardId};
        String pattern = "v1/vault/credit-cards/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return CreditCard.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, CreditCard.class);
    }

    public void delete(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.delete(apiContext);
    }

    public void delete(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        apiContext.setMaskRequestId(true);
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/vault/credit-cards/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        CreditCard.configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
    }

    public CreditCard update(String accessToken, List<Patch> patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.update(apiContext, patchRequest);
    }

    public CreditCard update(APIContext apiContext, List<Patch> patchRequest) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/vault/credit-cards/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = new GsonBuilder().create().toJson(patchRequest);
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, CreditCard.class);
    }

    public static CreditCardHistory list(String accessToken, Map<String, String> containerMap) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return CreditCard.list(apiContext, containerMap);
    }

    public static CreditCardHistory list(APIContext apiContext, Map<String, String> containerMap) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (containerMap == null) {
            throw new IllegalArgumentException("containerMap cannot be null");
        }
        Object[] parameters = new Object[]{containerMap};
        String pattern = "v1/vault/credit-cards?merchant_id={0}&external_card_id={1}&external_customer_id={2}&start_time={3}&end_time={4}&page={5}&page_size={6}&sort_order={7}&sort_by={8}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        CreditCardHistory creditCardHistory = CreditCard.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, CreditCardHistory.class);
        return creditCardHistory;
    }

    public static CreditCardHistory list(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("merchant_id", "");
        parameters.put("external_card_id", "");
        parameters.put("external_customer_id", "");
        parameters.put("start_time", "");
        parameters.put("end_time", "");
        parameters.put("page", "1");
        parameters.put("page_size", "10");
        parameters.put("sort_order", "asc");
        parameters.put("sort_by", "create_time");
        return CreditCard.list(apiContext, parameters);
    }
}

