/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base;

import com.paypal.base.APICallPreHandler;
import com.paypal.base.BaseAPIContext;
import com.paypal.base.SDKUtil;
import com.paypal.base.credential.ICredential;
import com.paypal.base.exception.ClientActionRequiredException;
import com.paypal.base.message.XMLMessageSerializer;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSOAPAPICallHandler
implements APICallPreHandler {
    private static XmlNamespaceProvider xmlNamespaceProvider;
    private static final String XMLNS_ATTRIBUTE_PREFIX = "xmlns:";
    private static final String SOAP_ENVELOPE_QNAME = "soapenv:Envelope";
    private static final String SOAP_HEADER_QNAME = "soapenv:Header";
    private static final String SOAP_BODY_QNAME = "soapenv:Body";
    private static final String SOAP_ENV_START = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" {0}>";
    private static final String SOAP_ENV_END = "</soapenv:Envelope>";
    private static final String SOAP_HEAD_START = "<soapenv:Header>{1}";
    private static final String SOAP_HEAD_END = "</soapenv:Header>";
    private static final String SOAP_BODY_START = "<soapenv:Body>{2}";
    private static final String SOAP_BODY_END = "</soapenv:Body>";
    private static final String SOAP_ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    private String rawPayLoad;
    private String headerString;
    private String namespaces;
    private Map<String, String> configurationMap = null;
    private String methodName = null;
    private BaseAPIContext baseAPIContext;
    private XMLMessageSerializer soapHeaderContent = null;
    private XMLMessageSerializer soapBodyContent = null;

    public static void setXmlNamespaceProvider(XmlNamespaceProvider xmlNamespaceProvider) {
        DefaultSOAPAPICallHandler.xmlNamespaceProvider = xmlNamespaceProvider;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void setHeaderString(String headerString) {
        this.headerString = headerString;
    }

    public String getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(String namespaces) {
        this.namespaces = namespaces;
    }

    public DefaultSOAPAPICallHandler(String rawPayLoad, String namespaces, String headerString) {
        this.rawPayLoad = rawPayLoad;
        this.namespaces = namespaces;
        this.headerString = headerString;
    }

    public DefaultSOAPAPICallHandler(String rawPayLoad, String namespaces, String headerString, Map<String, String> configurationMap) {
        if (configurationMap == null) {
            throw new IllegalArgumentException("configurationMap cannot be null");
        }
        this.rawPayLoad = rawPayLoad;
        this.namespaces = namespaces;
        this.headerString = headerString;
        this.configurationMap = SDKUtil.combineDefaultMap(configurationMap);
    }

    public DefaultSOAPAPICallHandler(XMLMessageSerializer soapBodyContent, BaseAPIContext baseAPIContext, Map<String, String> configurationMap, String methodName) {
        Map<String, String> configMap;
        Map<String, String> map = configMap = baseAPIContext != null && baseAPIContext.getConfigurationMap() != null ? baseAPIContext.getConfigurationMap() : configurationMap;
        if (configMap == null) {
            throw new IllegalArgumentException("configurationMap cannot be null");
        }
        this.configurationMap = SDKUtil.combineDefaultMap(configMap);
        this.baseAPIContext = baseAPIContext;
        this.methodName = methodName;
        if (baseAPIContext != null) {
            this.soapHeaderContent = baseAPIContext.getSOAPHeader();
        }
        this.soapBodyContent = soapBodyContent;
    }

    @Override
    public Map<String, String> getHeaderMap() {
        Map<String, String> headersMap = null;
        if (this.baseAPIContext != null) {
            headersMap = this.baseAPIContext.getHTTPHeaders();
        }
        if (headersMap == null) {
            headersMap = new HashMap<String, String>();
        }
        headersMap.put("Content-Type", "text/xml");
        return headersMap;
    }

    @Override
    public String getPayLoad() {
        String payload = null;
        if (this.soapBodyContent != null) {
            try {
                payload = this.getSoapEnvelope();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception [" + e.getClass().getSimpleName() + "] in creating PayLoad", e);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getSoapEnvelopeStart());
            stringBuilder.append(this.getSoapHeaderStart());
            stringBuilder.append(this.getSoapHeaderEnd());
            stringBuilder.append(this.getSoapBodyStart());
            stringBuilder.append(this.getSoapBodyEnd());
            stringBuilder.append(this.getSoapEnvelopeEnd());
            payload = stringBuilder.toString();
        }
        return payload;
    }

    @Override
    public String getEndPoint() {
        return this.configurationMap.get("service.EndPoint");
    }

    @Override
    public ICredential getCredential() {
        return null;
    }

    @Override
    public void validate() throws ClientActionRequiredException {
    }

    private String getSoapEnvelopeStart() {
        String envelope = null;
        envelope = this.namespaces != null ? MessageFormat.format(SOAP_ENV_START, this.namespaces) : SOAP_ENV_START;
        return envelope;
    }

    private String getSoapEnvelopeEnd() {
        return SOAP_ENV_END;
    }

    private String getSoapHeaderStart() {
        String header = null;
        header = this.headerString != null ? MessageFormat.format(SOAP_HEAD_START, null, this.headerString) : SOAP_HEAD_START;
        return header;
    }

    private String getSoapHeaderEnd() {
        return SOAP_HEAD_END;
    }

    private String getSoapBodyStart() {
        String body = null;
        body = this.rawPayLoad != null ? MessageFormat.format(SOAP_BODY_START, null, null, this.rawPayLoad) : SOAP_BODY_START;
        return body;
    }

    private String getSoapBodyEnd() {
        return SOAP_BODY_END;
    }

    private String getSoapEnvelope() throws TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException, SAXException, IOException {
        return this.nodeToString(this.getSoapEnvelopeAsNode());
    }

    private Node getSoapEnvelopeAsNode() throws ParserConfigurationException, SAXException, IOException {
        Element envelopeNode = null;
        Document soapDocument = this.getSoapEnvelopeAsDocument();
        if (this.soapHeaderContent != null) {
            Node headerContentNode = soapDocument.importNode(this.getNode(this.soapHeaderContent.toXMLString()), true);
            soapDocument.getDocumentElement().getElementsByTagNameNS(SOAP_ENV_NS, SOAP_HEADER_QNAME.substring(SOAP_HEADER_QNAME.indexOf(58) + 1)).item(0).appendChild(headerContentNode);
        }
        if (this.soapBodyContent != null) {
            Node bodyContentNode = soapDocument.importNode(this.getNode(this.soapBodyContent.toXMLString()), true);
            soapDocument.getDocumentElement().getElementsByTagNameNS(SOAP_ENV_NS, SOAP_BODY_QNAME.substring(SOAP_BODY_QNAME.indexOf(58) + 1)).item(0).appendChild(bodyContentNode);
        }
        envelopeNode = soapDocument.getDocumentElement();
        return envelopeNode;
    }

    private Document getSoapEnvelopeAsDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DOMImplementation domImpl = factory.newDocumentBuilder().getDOMImplementation();
        Document soapDocument = domImpl.createDocument(SOAP_ENV_NS, SOAP_ENVELOPE_QNAME, null);
        this.setNamespaces(soapDocument.getDocumentElement());
        Element soapHeader = soapDocument.createElementNS(SOAP_ENV_NS, SOAP_HEADER_QNAME);
        Element soapBody = soapDocument.createElementNS(SOAP_ENV_NS, SOAP_BODY_QNAME);
        soapDocument.getDocumentElement().appendChild(soapHeader);
        soapDocument.getDocumentElement().appendChild(soapBody);
        return soapDocument;
    }

    private void setNamespaces(Element element) {
        if (element != null && xmlNamespaceProvider != null) {
            for (Map.Entry<String, String> entry : xmlNamespaceProvider.getNamespaceMap().entrySet()) {
                element.setAttribute(XMLNS_ATTRIBUTE_PREFIX + entry.getKey().trim(), entry.getValue().trim());
            }
        }
    }

    private Node getNode(String nodeAsString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        InputSource inStream = new InputSource();
        inStream.setCharacterStream(new StringReader(nodeAsString));
        Document doc = dBuilder.parse(inStream);
        return doc.getChildNodes().item(0);
    }

    private String nodeToString(Node node) throws TransformerFactoryConfigurationError, TransformerException {
        StringWriter stringWriter = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface XmlNamespaceProvider {
        public Map<String, String> getNamespaceMap();
    }
}

