/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.httpcomponents.configuration;

import com.pastdev.httpcomponents.configuration.Configuration;
import com.pastdev.httpcomponents.configuration.Key;
import com.pastdev.httpcomponents.configuration.MapConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ConfigurationChain
implements Configuration {
    public List<Configuration> chain;

    private ConfigurationChain() {
    }

    public static ConfigurationChain primaryConfiguration(Configuration configuration) {
        ConfigurationChain chain = new ConfigurationChain();
        chain.chain = new ArrayList<Configuration>();
        chain.chain.add(configuration);
        return chain;
    }

    public ConfigurationChain fallbackTo(Configuration configuration) {
        this.chain.add(configuration);
        return this;
    }

    @Override
    public <T> T get(Key key, Class<T> type) {
        return this.get(key.key(), type);
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        T value;
        block1: {
            Configuration configuration;
            value = null;
            if (this.chain == null) break block1;
            Iterator<Configuration> i$ = this.chain.iterator();
            while (i$.hasNext() && (value = (T)(configuration = i$.next()).get(key, type)) == null) {
            }
        }
        return value;
    }

    @Override
    public Configuration getConfiguration(Key prefix) {
        return this.getConfiguration(prefix.key());
    }

    @Override
    public Configuration getConfiguration(String prefix) {
        if (this.chain != null) {
            ConfigurationChain newConfig = null;
            for (Configuration configuration : this.chain) {
                if (newConfig == null) {
                    newConfig = ConfigurationChain.primaryConfiguration(configuration.getConfiguration(prefix));
                    continue;
                }
                newConfig.fallbackTo(configuration.getConfiguration(prefix));
            }
            return newConfig;
        }
        return new MapConfiguration();
    }

    @Override
    public Boolean has(Key key) {
        return this.has(key.key());
    }

    @Override
    public Boolean has(String key) {
        Boolean value;
        block1: {
            Configuration configuration;
            value = false;
            if (this.chain == null && this.chain.isEmpty()) break block1;
            Iterator<Configuration> i$ = this.chain.iterator();
            while (i$.hasNext() && !(value = (configuration = i$.next()).has(key)).booleanValue()) {
            }
        }
        return value;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        if (this.chain != null || !this.chain.isEmpty()) {
            for (Configuration configuration : this.chain) {
                keySet.addAll(configuration.keySet());
            }
        }
        return keySet;
    }
}

