/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseInstallation;
import com.parse.ParseQuery;
import com.parse.ParseRESTCommand;
import com.parse.PointerEncoder;
import com.parse.http.ParseHttpRequest;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParseRESTPushCommand
extends ParseRESTCommand {
    static final String KEY_CHANNELS = "channels";
    static final String KEY_WHERE = "where";
    static final String KEY_DEVICE_TYPE = "deviceType";
    static final String KEY_EXPIRATION_TIME = "expiration_time";
    static final String KEY_EXPIRATION_INTERVAL = "expiration_interval";
    static final String KEY_PUSH_TIME = "push_time";
    static final String KEY_DATA = "data";

    public ParseRESTPushCommand(String httpPath, ParseHttpRequest.Method httpMethod, JSONObject parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static ParseRESTPushCommand sendPushCommand(ParseQuery.State<ParseInstallation> query, Set<String> targetChannels, String targetDeviceType, Long expirationTime, Long expirationInterval, Long pushTime, JSONObject payload, String sessionToken) {
        JSONObject parameters = new JSONObject();
        try {
            if (targetChannels != null) {
                parameters.put(KEY_CHANNELS, (Object)new JSONArray(targetChannels));
            } else {
                JSONObject whereJSON = null;
                if (query != null) {
                    ParseQuery.QueryConstraints where = query.constraints();
                    whereJSON = (JSONObject)PointerEncoder.get().encode(where);
                }
                if (targetDeviceType != null) {
                    whereJSON = new JSONObject();
                    whereJSON.put(KEY_DEVICE_TYPE, (Object)targetDeviceType);
                }
                if (whereJSON == null) {
                    whereJSON = new JSONObject();
                }
                parameters.put(KEY_WHERE, (Object)whereJSON);
            }
            if (expirationTime != null) {
                parameters.put(KEY_EXPIRATION_TIME, (Object)expirationTime);
            } else if (expirationInterval != null) {
                parameters.put(KEY_EXPIRATION_INTERVAL, (Object)expirationInterval);
            }
            if (pushTime != null) {
                parameters.put(KEY_PUSH_TIME, (Object)pushTime);
            }
            if (payload != null) {
                parameters.put(KEY_DATA, (Object)payload);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return new ParseRESTPushCommand("push", ParseHttpRequest.Method.POST, parameters, sessionToken);
    }
}

