/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.ParseHttpClient;
import com.parse.ParsePush;
import com.parse.ParseRESTCommand;
import com.parse.ParseRESTPushCommand;

class ParsePushController {
    static final String DEVICE_TYPE_IOS = "ios";
    static final String DEVICE_TYPE_ANDROID = "android";
    private final ParseHttpClient restClient;

    public ParsePushController(ParseHttpClient restClient) {
        this.restClient = restClient;
    }

    public Task<Void> sendInBackground(ParsePush.State state, String sessionToken) {
        return this.buildRESTSendPushCommand(state, sessionToken).executeAsync(this.restClient).makeVoid();
    }

    ParseRESTCommand buildRESTSendPushCommand(ParsePush.State state, String sessionToken) {
        String deviceType = null;
        if (state.queryState() == null) {
            boolean willPushToIOS;
            boolean willPushToAndroid = state.pushToAndroid() != null && state.pushToAndroid() != false;
            boolean bl = willPushToIOS = state.pushToIOS() != null && state.pushToIOS() != false;
            if (!willPushToIOS || !willPushToAndroid) {
                if (willPushToIOS) {
                    deviceType = DEVICE_TYPE_IOS;
                } else if (willPushToAndroid) {
                    deviceType = DEVICE_TYPE_ANDROID;
                }
            }
        }
        return ParseRESTPushCommand.sendPushCommand(state.queryState(), state.channelSet(), deviceType, state.expirationTime(), state.expirationTimeInterval(), state.pushTime(), state.data(), sessionToken);
    }
}

