/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Continuation;
import bolts.Task;
import com.parse.ManifestInfo;
import com.parse.PLog;
import com.parse.ParseCorePlugins;
import com.parse.ParseCurrentInstallationController;
import com.parse.ParseInstallation;
import com.parse.PushType;
import java.util.Collections;
import java.util.List;

class ParsePushChannelsController {
    private static final String TAG = "com.parse.ParsePushChannelsController";
    private static boolean loggedManifestError = false;

    ParsePushChannelsController() {
    }

    private static ParseCurrentInstallationController getCurrentInstallationController() {
        return ParseCorePlugins.getInstance().getCurrentInstallationController();
    }

    public Task<Void> subscribeInBackground(final String channel) {
        ParsePushChannelsController.checkManifestAndLogErrorIfNecessary();
        if (channel == null) {
            throw new IllegalArgumentException("Can't subscribe to null channel.");
        }
        return ParsePushChannelsController.getCurrentInstallationController().getAsync().onSuccessTask((Continuation)new Continuation<ParseInstallation, Task<Void>>(){

            public Task<Void> then(Task<ParseInstallation> task) throws Exception {
                ParseInstallation installation = (ParseInstallation)task.getResult();
                List channels = installation.getList("channels");
                if (channels == null || installation.isDirty("channels") || !channels.contains(channel)) {
                    installation.addUnique("channels", channel);
                    return installation.saveInBackground();
                }
                return Task.forResult(null);
            }
        });
    }

    public Task<Void> unsubscribeInBackground(final String channel) {
        ParsePushChannelsController.checkManifestAndLogErrorIfNecessary();
        if (channel == null) {
            throw new IllegalArgumentException("Can't unsubscribe from null channel.");
        }
        return ParsePushChannelsController.getCurrentInstallationController().getAsync().onSuccessTask((Continuation)new Continuation<ParseInstallation, Task<Void>>(){

            public Task<Void> then(Task<ParseInstallation> task) throws Exception {
                ParseInstallation installation = (ParseInstallation)task.getResult();
                List channels = installation.getList("channels");
                if (channels != null && channels.contains(channel)) {
                    installation.removeAll("channels", Collections.singletonList(channel));
                    return installation.saveInBackground();
                }
                return Task.forResult(null);
            }
        });
    }

    private static void checkManifestAndLogErrorIfNecessary() {
        if (!loggedManifestError && ManifestInfo.getPushType() == PushType.NONE) {
            loggedManifestError = true;
            PLog.e(TAG, "Tried to subscribe or unsubscribe from a channel, but push is not enabled correctly. " + ManifestInfo.getNonePushTypeLogMessage());
        }
    }
}

