/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Parcel;
import com.parse.ParseObject;
import com.parse.ParseParcelDecoder;
import java.util.HashMap;
import java.util.Map;

class ParseObjectParcelDecoder
extends ParseParcelDecoder {
    private Map<String, ParseObject> objects = new HashMap<String, ParseObject>();

    public void addKnownObject(ParseObject object) {
        this.objects.put(this.getObjectOrLocalId(object), object);
    }

    @Override
    protected ParseObject decodePointer(Parcel source) {
        String className = source.readString();
        String objectId = source.readString();
        if (this.objects.containsKey(objectId)) {
            return this.objects.get(objectId);
        }
        ParseObject object = ParseObject.createWithoutData(className, objectId);
        this.objects.put(objectId, object);
        return object;
    }

    private String getObjectOrLocalId(ParseObject object) {
        return object.getObjectId() != null ? object.getObjectId() : object.getOrCreateLocalId();
    }
}

