/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.support.annotation.Nullable;
import com.parse.http.ParseHttpBody;
import com.parse.http.ParseHttpRequest;
import com.parse.http.ParseHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;

class ParseHttpClient {
    private static final String MAX_CONNECTIONS_PROPERTY_NAME = "http.maxConnections";
    private static final String KEEP_ALIVE_PROPERTY_NAME = "http.keepAlive";
    private OkHttpClient okHttpClient;
    private boolean hasExecuted;

    static ParseHttpClient createClient(@Nullable OkHttpClient.Builder builder) {
        return new ParseHttpClient(builder);
    }

    static void setMaxConnections(int maxConnections) {
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("Max connections should be large than 0");
        }
        System.setProperty(MAX_CONNECTIONS_PROPERTY_NAME, String.valueOf(maxConnections));
    }

    static void setKeepAlive(boolean isKeepAlive) {
        System.setProperty(KEEP_ALIVE_PROPERTY_NAME, String.valueOf(isKeepAlive));
    }

    ParseHttpClient(@Nullable OkHttpClient.Builder builder) {
        if (builder == null) {
            builder = new OkHttpClient.Builder();
        }
        this.okHttpClient = builder.build();
    }

    public final ParseHttpResponse execute(ParseHttpRequest request) throws IOException {
        if (!this.hasExecuted) {
            this.hasExecuted = true;
        }
        return this.executeInternal(request);
    }

    ParseHttpResponse executeInternal(ParseHttpRequest parseRequest) throws IOException {
        Request okHttpRequest = this.getRequest(parseRequest);
        Call okHttpCall = this.okHttpClient.newCall(okHttpRequest);
        Response okHttpResponse = okHttpCall.execute();
        return this.getResponse(okHttpResponse);
    }

    ParseHttpResponse getResponse(Response okHttpResponse) throws IOException {
        int statusCode = okHttpResponse.code();
        InputStream content = okHttpResponse.body().byteStream();
        int totalSize = (int)okHttpResponse.body().contentLength();
        String reasonPhrase = okHttpResponse.message();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String name : okHttpResponse.headers().names()) {
            headers.put(name, okHttpResponse.header(name));
        }
        String contentType = null;
        ResponseBody body = okHttpResponse.body();
        if (body != null && body.contentType() != null) {
            contentType = body.contentType().toString();
        }
        return new ParseHttpResponse.Builder().setStatusCode(statusCode).setContent(content).setTotalSize(totalSize).setReasonPhrase(reasonPhrase).setHeaders(headers).setContentType(contentType).build();
    }

    Request getRequest(ParseHttpRequest parseRequest) throws IOException {
        Request.Builder okHttpRequestBuilder = new Request.Builder();
        ParseHttpRequest.Method method = parseRequest.getMethod();
        switch (method) {
            case GET: {
                okHttpRequestBuilder.get();
                break;
            }
            case DELETE: 
            case POST: 
            case PUT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported http method " + method.toString());
            }
        }
        okHttpRequestBuilder.url(parseRequest.getUrl());
        Headers.Builder okHttpHeadersBuilder = new Headers.Builder();
        for (Map.Entry<String, String> entry : parseRequest.getAllHeaders().entrySet()) {
            okHttpHeadersBuilder.add(entry.getKey(), entry.getValue());
        }
        Headers okHttpHeaders = okHttpHeadersBuilder.build();
        okHttpRequestBuilder.headers(okHttpHeaders);
        ParseHttpBody parseBody = parseRequest.getBody();
        ParseOkHttpRequestBody okHttpRequestBody = null;
        if (parseBody != null) {
            okHttpRequestBody = new ParseOkHttpRequestBody(parseBody);
        }
        switch (method) {
            case PUT: {
                okHttpRequestBuilder.put((RequestBody)okHttpRequestBody);
                break;
            }
            case POST: {
                okHttpRequestBuilder.post((RequestBody)okHttpRequestBody);
                break;
            }
            case DELETE: {
                okHttpRequestBuilder.delete((RequestBody)okHttpRequestBody);
            }
        }
        return okHttpRequestBuilder.build();
    }

    private static class ParseOkHttpRequestBody
    extends RequestBody {
        private ParseHttpBody parseBody;

        ParseOkHttpRequestBody(ParseHttpBody parseBody) {
            this.parseBody = parseBody;
        }

        public long contentLength() throws IOException {
            return this.parseBody.getContentLength();
        }

        public MediaType contentType() {
            String contentType = this.parseBody.getContentType();
            return contentType == null ? null : MediaType.parse((String)this.parseBody.getContentType());
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            this.parseBody.writeTo(bufferedSink.outputStream());
        }
    }
}

