/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.ParseCorePlugins;
import com.parse.ParseDecoder;
import com.parse.ParseExecutors;
import com.parse.ParseFileUtils;
import com.parse.ParseObject;
import com.parse.ParseObjectCurrentCoder;
import com.parse.ParseObjectStore;
import com.parse.ParseObjectSubclassingController;
import com.parse.PointerEncoder;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

class FileObjectStore<T extends ParseObject>
implements ParseObjectStore<T> {
    private final String className;
    private final File file;
    private final ParseObjectCurrentCoder coder;

    private static ParseObjectSubclassingController getSubclassingController() {
        return ParseCorePlugins.getInstance().getSubclassingController();
    }

    private static void saveToDisk(ParseObjectCurrentCoder coder, ParseObject current, File file) {
        JSONObject json = coder.encode(current.getState(), null, PointerEncoder.get());
        try {
            ParseFileUtils.writeJSONObjectToFile(file, json);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static <T extends ParseObject> T getFromDisk(ParseObjectCurrentCoder coder, File file, ParseObject.State.Init builder) {
        JSONObject json;
        try {
            json = ParseFileUtils.readFileToJSONObject(file);
        }
        catch (IOException | JSONException e) {
            return null;
        }
        Object newState = ((ParseObject.State.Init)coder.decode(builder, json, ParseDecoder.get()).isComplete(true)).build();
        return ParseObject.from(newState);
    }

    public FileObjectStore(Class<T> clazz, File file, ParseObjectCurrentCoder coder) {
        this(FileObjectStore.getSubclassingController().getClassName(clazz), file, coder);
    }

    public FileObjectStore(String className, File file, ParseObjectCurrentCoder coder) {
        this.className = className;
        this.file = file;
        this.coder = coder;
    }

    @Override
    public Task<Void> setAsync(final T object) {
        return Task.call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FileObjectStore.saveToDisk(FileObjectStore.this.coder, object, FileObjectStore.this.file);
                return null;
            }
        }, (Executor)ParseExecutors.io());
    }

    @Override
    public Task<T> getAsync() {
        return Task.call((Callable)new Callable<T>(){

            @Override
            public T call() throws Exception {
                if (!FileObjectStore.this.file.exists()) {
                    return null;
                }
                return FileObjectStore.getFromDisk(FileObjectStore.this.coder, FileObjectStore.this.file, ParseObject.State.newBuilder(FileObjectStore.this.className));
            }
        }, (Executor)ParseExecutors.io());
    }

    @Override
    public Task<Boolean> existsAsync() {
        return Task.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return FileObjectStore.this.file.exists();
            }
        }, (Executor)ParseExecutors.io());
    }

    @Override
    public Task<Void> deleteAsync() {
        return Task.call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (FileObjectStore.this.file.exists() && !ParseFileUtils.deleteQuietly(FileObjectStore.this.file)) {
                    throw new RuntimeException("Unable to delete");
                }
                return null;
            }
        }, (Executor)ParseExecutors.io());
    }
}

