/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.view;

import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import com.parkingwang.vehiclekeyboard.R;
import java.util.ArrayList;

abstract class FieldViewGroup {
    private static final String TAG = "InputView.ButtonGroup";
    private static final int REUSE_INDEX = 6;
    private final Button[] mFieldViews = new Button[9];

    public FieldViewGroup() {
        int[] resIds = new int[]{R.id.number_0, R.id.number_1, R.id.number_2, R.id.number_3, R.id.number_4, R.id.number_5, R.id.number_6, R.id.number_6_of_end, R.id.number_7_of_end};
        for (int i = 0; i < resIds.length; ++i) {
            this.mFieldViews[i] = this.findViewById(resIds[i]);
            this.mFieldViews[i].setTag((Object)("[RAW.idx:" + i + "]"));
        }
        this.changeTo8Fields();
    }

    protected abstract Button findViewById(int var1);

    public void setTextToFields(String text) {
        for (Button f : this.mFieldViews) {
            f.setText(null);
        }
        char[] chars = text.toCharArray();
        if (chars.length >= 8) {
            this.changeTo8Fields();
        } else {
            this.changeTo7Fields();
        }
        Button[] fields = this.getAvailableFields();
        for (int i = 0; i < fields.length; ++i) {
            String txt = i < chars.length ? String.valueOf(chars[i]) : null;
            fields[i].setText((CharSequence)txt);
        }
    }

    public Button[] getAvailableFields() {
        ArrayList<Button> output = new ArrayList<Button>(8);
        for (int i = 0; i < this.mFieldViews.length; ++i) {
            if (i < 6) {
                output.add(this.mFieldViews[i]);
                continue;
            }
            if (!this.mFieldViews[i].isShown()) continue;
            output.add(this.mFieldViews[i]);
        }
        return output.toArray(new Button[output.size()]);
    }

    public Button getFieldAt(int index) {
        if (index < 6) {
            return this.mFieldViews[index];
        }
        if (index == 6) {
            if (this.mFieldViews[6].isShown()) {
                return this.mFieldViews[6];
            }
            return this.mFieldViews[7];
        }
        return this.mFieldViews[index + 1];
    }

    public boolean changeTo7Fields() {
        if (this.mFieldViews[7].isShown()) {
            return false;
        }
        this.mFieldViews[6].setVisibility(8);
        this.mFieldViews[7].setVisibility(0);
        this.mFieldViews[8].setVisibility(8);
        this.mFieldViews[6].setText(null);
        this.mFieldViews[8].setText(null);
        return true;
    }

    public boolean changeTo8Fields() {
        if (this.mFieldViews[8].isShown()) {
            return false;
        }
        this.mFieldViews[6].setVisibility(0);
        this.mFieldViews[7].setVisibility(8);
        this.mFieldViews[8].setVisibility(0);
        this.mFieldViews[6].setText(this.mFieldViews[7].getText());
        this.mFieldViews[7].setText(null);
        return true;
    }

    public Button getLastField() {
        if (this.mFieldViews[8].isShown()) {
            return this.mFieldViews[8];
        }
        return this.mFieldViews[7];
    }

    public Button getFirstSelectedFieldOrNull() {
        for (Button field : this.getAvailableFields()) {
            if (!field.isSelected()) continue;
            return field;
        }
        return null;
    }

    public Button getLastFilledFieldOrNull() {
        Button[] fields = this.getAvailableFields();
        for (int i = fields.length - 1; i >= 0; --i) {
            if (TextUtils.isEmpty((CharSequence)fields[i].getText())) continue;
            return fields[i];
        }
        return null;
    }

    public Button getFirstEmptyField() {
        Button[] fields = this.getAvailableFields();
        Button out = fields[0];
        Button[] buttonArray = fields;
        int n = buttonArray.length;
        for (int i = 0; i < n; ++i) {
            Button field;
            out = field = buttonArray[i];
            CharSequence keyTxt = field.getText();
            if (TextUtils.isEmpty((CharSequence)keyTxt)) break;
        }
        Log.d((String)TAG, (String)("[-- CheckEmpty --]: Btn.idx: " + out.getTag() + ", Btn.text: " + out.getText() + ", Btn.addr: " + out));
        return out;
    }

    public int getNextIndexOfField(Button target) {
        Button[] fields = this.getAvailableFields();
        for (int i = 0; i < fields.length; ++i) {
            if (target != fields[i]) continue;
            return Math.min(fields.length - 1, i + 1);
        }
        return 0;
    }

    public boolean isAllFieldsFilled() {
        for (Button field : this.getAvailableFields()) {
            if (!TextUtils.isEmpty((CharSequence)field.getText())) continue;
            return false;
        }
        return true;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (Button field : this.getAvailableFields()) {
            sb.append(field.getText());
        }
        return sb.toString();
    }

    public void setupAllFieldsTextSize(float size) {
        for (Button field : this.mFieldViews) {
            field.setTextSize(0, size);
        }
    }

    public void setupAllFieldsOnClickListener(View.OnClickListener listener) {
        for (Button field : this.mFieldViews) {
            field.setOnClickListener(listener);
        }
    }
}

