/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import com.parkingwang.keyboard.Texts;
import com.parkingwang.vehiclekeyboard.R;

public class BubbleDrawable
extends Drawable {
    private static final float ANCHOR_Y = 0.87288135f;
    private static final float TEXT_CENTER_Y = 0.34745762f;
    private final Drawable mBackgroundDrawable;
    private final Paint mTextPaint = new Paint(5);
    private final float mCNTextSize;
    private final float mENTextSize;
    private String mText;

    public BubbleDrawable(Context context) {
        Resources resources = context.getResources();
        this.mBackgroundDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.pwk_key_bubble_bg);
        this.setBounds(0, 0, this.mBackgroundDrawable.getIntrinsicWidth(), this.mBackgroundDrawable.getIntrinsicHeight());
        this.mCNTextSize = resources.getDimensionPixelSize(R.dimen.pwk_keyboard_bubble_cn_text_size);
        this.mENTextSize = resources.getDimensionPixelSize(R.dimen.pwk_keyboard_bubble_en_text_size);
        this.mTextPaint.setColor(ContextCompat.getColor((Context)context, (int)R.color.pwk_key_pressed_bubble_text));
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setFakeBoldText(true);
    }

    public void setText(String text) {
        this.mText = text;
        if (Texts.isEnglishLetterOrDigit(text)) {
            this.mTextPaint.setTextSize(this.mENTextSize);
        } else {
            this.mTextPaint.setTextSize(this.mCNTextSize);
        }
    }

    public void draw(@NonNull Canvas canvas) {
        canvas.save();
        canvas.translate(0.0f, 0.12711865f * (float)this.getIntrinsicHeight());
        this.mBackgroundDrawable.draw(canvas);
        float textCenterX = this.getIntrinsicWidth() / 2;
        float textCenterY = (float)this.getIntrinsicHeight() * 0.34745762f - (this.mTextPaint.ascent() + this.mTextPaint.descent()) / 2.0f;
        canvas.drawText(this.mText, textCenterX, textCenterY, this.mTextPaint);
        canvas.restore();
    }

    public void setAlpha(int alpha) {
        this.mBackgroundDrawable.setAlpha(alpha);
        this.mTextPaint.setAlpha(alpha);
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mTextPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return 0;
    }

    public int getIntrinsicWidth() {
        return this.mBackgroundDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mBackgroundDrawable.getIntrinsicHeight();
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.mBackgroundDrawable.setBounds(left, top, right, bottom);
    }
}

