/*
 * Decompiled with CFR 0.152.
 */
package com.parkingwang.keyboard.engine;

import com.parkingwang.keyboard.engine.Context;
import com.parkingwang.keyboard.engine.KeyEntry;
import com.parkingwang.keyboard.engine.KeyType;
import com.parkingwang.keyboard.engine.LayoutEntry;
import com.parkingwang.keyboard.engine.RowEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LayoutMixer {
    private final List<KeyTransformer> mKeyTransformers = new ArrayList<KeyTransformer>();
    private final List<LayoutTransformer> mLayoutTransformers = new ArrayList<LayoutTransformer>();

    public LayoutEntry transform(Context context, LayoutEntry layout2) {
        LayoutEntry out = layout2;
        for (LayoutTransformer t : this.mLayoutTransformers) {
            LayoutEntry ret = t.transformLayout(context, out);
            if (null == ret) continue;
            out = ret;
        }
        return out;
    }

    public LayoutEntry mix(Context context, LayoutEntry layout2) {
        LayoutEntry output = new LayoutEntry();
        for (RowEntry layoutRow : layout2) {
            RowEntry row = new RowEntry(layoutRow.size());
            Iterator iterator = layoutRow.iterator();
            while (iterator.hasNext()) {
                KeyEntry item;
                KeyEntry key = item = (KeyEntry)iterator.next();
                for (KeyTransformer keyTransformer : this.mKeyTransformers) {
                    KeyEntry ret = keyTransformer.transformKey(context, key);
                    if (null == ret) continue;
                    key = ret;
                }
                row.add(key);
            }
            output.add(row);
        }
        return output;
    }

    public void addKeyTransformer(KeyTransformer keyTransformer) {
        this.mKeyTransformers.add(keyTransformer);
    }

    public void addLayoutTransformer(LayoutTransformer transformer) {
        this.mLayoutTransformers.add(transformer);
    }

    public static abstract class AbstractTypedKeyTransformer
    implements KeyTransformer {
        private final KeyType mKeyType;

        public AbstractTypedKeyTransformer(KeyType keyType) {
            this.mKeyType = keyType;
        }

        @Override
        public final KeyEntry transformKey(Context context, KeyEntry key) {
            if (this.mKeyType.equals((Object)key.keyType)) {
                return this.transform(context, key);
            }
            return key;
        }

        protected abstract KeyEntry transform(Context var1, KeyEntry var2);
    }

    public static interface LayoutTransformer {
        public LayoutEntry transformLayout(Context var1, LayoutEntry var2);
    }

    public static interface KeyTransformer {
        public KeyEntry transformKey(Context var1, KeyEntry var2);
    }
}

