/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.bootstrap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.palantir.javaformat.bootstrap.FormatterCommandRunner;
import com.palantir.javaformat.bootstrap.ImmutableFormatterNativeImageArgs;
import com.palantir.javaformat.bootstrap.RangeUtils;
import com.palantir.javaformat.java.FormatterService;
import com.palantir.javaformat.java.Replacement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public class NativeImageFormatterService
implements FormatterService {
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new GuavaModule())).build();
    private final Path nativeImagePath;

    public NativeImageFormatterService(Path nativeImagePath) {
        this.nativeImagePath = nativeImagePath;
    }

    public ImmutableList<Replacement> getFormatReplacements(String input, Collection<Range<Integer>> ranges) {
        try {
            ImmutableFormatterNativeImageArgs command = FormatterNativeImageArgs.builder().nativeImagePath(this.nativeImagePath).outputReplacements(true).characterRanges(ranges.stream().map(RangeUtils::toStringRange).collect(Collectors.toList())).build();
            Optional<String> output = FormatterCommandRunner.runWithStdin(command.toArgs(), input, Optional.ofNullable(this.nativeImagePath.getParent()));
            if (output.isEmpty() || output.get().isEmpty()) {
                return ImmutableList.of();
            }
            return (ImmutableList)MAPPER.readValue(output.get(), (TypeReference)new TypeReference<ImmutableList<Replacement>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException("Error running the native image command", e);
        }
    }

    public String formatSourceReflowStringsAndFixImports(String input) {
        try {
            return this.runFormatterCommand(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Error running the native image command", e);
        }
    }

    public String fixImports(String input) {
        try {
            return this.runFormatterCommand(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Error running the native image command", e);
        }
    }

    private String runFormatterCommand(String input) throws IOException {
        ImmutableFormatterNativeImageArgs command = FormatterNativeImageArgs.builder().nativeImagePath(this.nativeImagePath).outputReplacements(false).build();
        return FormatterCommandRunner.runWithStdin(command.toArgs(), input, Optional.ofNullable(this.nativeImagePath.getParent())).orElse(input);
    }

    @Value.Immutable
    static interface FormatterNativeImageArgs {
        public List<String> characterRanges();

        public boolean outputReplacements();

        public Path nativeImagePath();

        default public List<String> toArgs() {
            ImmutableList.Builder args = ImmutableList.builder().add((Object)this.nativeImagePath().toAbsolutePath().toString());
            if (!this.characterRanges().isEmpty()) {
                args.add((Object[])new String[]{"--character-ranges", Joiner.on((char)',').join(this.characterRanges())});
            }
            if (this.outputReplacements()) {
                args.add((Object)"--output-replacements");
            }
            return args.add((Object)"--palantir").add((Object)"-").build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        extends ImmutableFormatterNativeImageArgs.Builder {
        }
    }
}

