/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.base.Preconditions;
import com.palantir.javaformat.gradle.ExecutableTransform;
import com.palantir.javaformat.gradle.JavaFormatExtension;
import com.palantir.platform.Architecture;
import com.palantir.platform.OperatingSystem;
import java.util.Optional;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public final class NativeImageFormatProviderPlugin
implements Plugin<Project> {
    private static final Logger log = Logging.getLogger(NativeImageFormatProviderPlugin.class);
    static final String NATIVE_CONFIGURATION_NAME = "palantirJavaFormatNative";

    public void apply(Project rootProject) {
        Preconditions.checkState((rootProject == rootProject.getRootProject() ? 1 : 0) != 0, (Object)"May only apply com.palantir.java-format-provider to the root project");
        if (!NativeImageFormatProviderPlugin.isNativeImageConfigured(rootProject)) {
            log.info("Skipping native image configuration as it is not supported on this platform");
            return;
        }
        String implementationVersion = JavaFormatExtension.class.getPackage().getImplementationVersion();
        OperatingSystem operatingSystem = OperatingSystem.get();
        rootProject.getConfigurations().register(NATIVE_CONFIGURATION_NAME, conf -> {
            conf.setDescription("Internal configuration for resolving the palantir-java-format native image");
            conf.setVisible(false);
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(true);
            conf.defaultDependencies(deps -> deps.add((Object)rootProject.getDependencies().create((Object)String.format("com.palantir.javaformat:palantir-java-format-native:%s:nativeImage-%s_%s@%s", implementationVersion, operatingSystem.uiName(), Architecture.get().uiName(), NativeImageFormatProviderPlugin.getExtension(operatingSystem)))));
            conf.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"executable-nativeImage");
        });
        rootProject.getDependencies().registerTransform(ExecutableTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)NativeImageFormatProviderPlugin.getExtension(operatingSystem));
            transformSpec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"executable-nativeImage");
        });
    }

    public static boolean isNativeImageConfigured(Project project) {
        return NativeImageFormatProviderPlugin.isNativeImageSupported() && NativeImageFormatProviderPlugin.isNativeFlagEnabled(project);
    }

    private static boolean isNativeImageSupported() {
        OperatingSystem os = OperatingSystem.get();
        return os.equals((Object)OperatingSystem.LINUX_GLIBC) || os.equals((Object)OperatingSystem.MACOS) && Architecture.get().equals((Object)Architecture.AARCH64);
    }

    private static boolean isNativeFlagEnabled(Project project) {
        return Optional.ofNullable(project.findProperty("palantir.native.formatter")).map(value -> Boolean.parseBoolean((String)value)).orElse(false);
    }

    static String getExtension(OperatingSystem operatingSystem) {
        if (operatingSystem.equals((Object)OperatingSystem.WINDOWS)) {
            return "exe";
        }
        return "bin";
    }
}

