/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.base.Preconditions;
import com.palantir.javaformat.gradle.JavaFormatExtension;
import com.palantir.javaformat.gradle.NativeImageFormatProviderPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public final class PalantirJavaFormatProviderPlugin
implements Plugin<Project> {
    static final String CONFIGURATION_NAME = "palantirJavaFormat";

    public void apply(Project rootProject) {
        Preconditions.checkState((rootProject == rootProject.getRootProject() ? 1 : 0) != 0, (Object)"May only apply com.palantir.java-format-provider to the root project");
        rootProject.getPluginManager().apply(NativeImageFormatProviderPlugin.class);
        Configuration configuration = (Configuration)rootProject.getConfigurations().create(CONFIGURATION_NAME, conf -> {
            conf.setDescription("Internal configuration for resolving the palantir-java-format implementation");
            conf.setVisible(false);
            conf.setCanBeConsumed(false);
            conf.defaultDependencies(deps -> deps.add((Object)rootProject.getDependencies().create((Object)String.format("com.palantir.javaformat:palantir-java-format:%s", JavaFormatExtension.class.getPackage().getImplementationVersion()))));
        });
        rootProject.getExtensions().create(CONFIGURATION_NAME, JavaFormatExtension.class, new Object[]{configuration});
    }
}

