package com.palantir.docker.compose;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.palantir.docker.compose.configuration.DockerComposeFiles;
import com.palantir.docker.compose.configuration.ProjectName;
import com.palantir.docker.compose.configuration.ShutdownStrategy;
import com.palantir.docker.compose.connection.Cluster;
import com.palantir.docker.compose.connection.DockerMachine;
import com.palantir.docker.compose.connection.waiting.ClusterWait;
import com.palantir.docker.compose.execution.Docker;
import com.palantir.docker.compose.execution.DockerCompose;
import com.palantir.docker.compose.execution.DockerComposeExecutable;
import com.palantir.docker.compose.execution.DockerExecutable;
import com.palantir.docker.compose.logging.LogCollector;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.joda.time.ReadableDuration;

/**
 * Immutable implementation of {@link DockerComposeRule}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new DockerComposeRule.Builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "DockerComposeRule"})
public final class ImmutableDockerComposeRule extends DockerComposeRule {
  private final DockerComposeFiles files;
  private final ImmutableList<ClusterWait> clusterWaits;
  private final DockerMachine machine;
  private final ProjectName projectName;
  private final DockerComposeExecutable dockerComposeExecutable;
  private final DockerExecutable dockerExecutable;
  private final Docker docker;
  private final ShutdownStrategy shutdownStrategy;
  private final DockerCompose dockerCompose;
  private final Cluster containers;
  private final int retryAttempts;
  private final boolean removeConflictingContainersOnStartup;
  private final boolean pullOnStartup;
  private final ReadableDuration nativeServiceHealthCheckTimeout;
  private final LogCollector logCollector;

  private ImmutableDockerComposeRule(ImmutableDockerComposeRule.Builder builder) {
    this.files = builder.files;
    this.clusterWaits = builder.clusterWaits.build();
    if (builder.machineIsSet()) {
      initShim.machine(builder.machine);
    }
    if (builder.projectNameIsSet()) {
      initShim.projectName(builder.projectName);
    }
    if (builder.dockerComposeExecutableIsSet()) {
      initShim.dockerComposeExecutable(builder.dockerComposeExecutable);
    }
    if (builder.dockerExecutableIsSet()) {
      initShim.dockerExecutable(builder.dockerExecutable);
    }
    if (builder.dockerIsSet()) {
      initShim.docker(builder.docker);
    }
    if (builder.shutdownStrategyIsSet()) {
      initShim.shutdownStrategy(builder.shutdownStrategy);
    }
    if (builder.dockerComposeIsSet()) {
      initShim.dockerCompose(builder.dockerCompose);
    }
    if (builder.containersIsSet()) {
      initShim.containers(builder.containers);
    }
    if (builder.retryAttemptsIsSet()) {
      initShim.retryAttempts(builder.retryAttempts);
    }
    if (builder.removeConflictingContainersOnStartupIsSet()) {
      initShim.removeConflictingContainersOnStartup(builder.removeConflictingContainersOnStartup);
    }
    if (builder.pullOnStartupIsSet()) {
      initShim.pullOnStartup(builder.pullOnStartup);
    }
    if (builder.nativeServiceHealthCheckTimeoutIsSet()) {
      initShim.nativeServiceHealthCheckTimeout(builder.nativeServiceHealthCheckTimeout);
    }
    if (builder.logCollectorIsSet()) {
      initShim.logCollector(builder.logCollector);
    }
    this.machine = initShim.machine();
    this.projectName = initShim.projectName();
    this.dockerComposeExecutable = initShim.dockerComposeExecutable();
    this.dockerExecutable = initShim.dockerExecutable();
    this.docker = initShim.docker();
    this.shutdownStrategy = initShim.shutdownStrategy();
    this.dockerCompose = initShim.dockerCompose();
    this.containers = initShim.containers();
    this.retryAttempts = initShim.retryAttempts();
    this.removeConflictingContainersOnStartup = initShim.removeConflictingContainersOnStartup();
    this.pullOnStartup = initShim.pullOnStartup();
    this.nativeServiceHealthCheckTimeout = initShim.nativeServiceHealthCheckTimeout();
    this.logCollector = initShim.logCollector();
    this.initShim = null;
  }

  private ImmutableDockerComposeRule(
      DockerComposeFiles files,
      ImmutableList<ClusterWait> clusterWaits,
      DockerMachine machine,
      ProjectName projectName,
      DockerComposeExecutable dockerComposeExecutable,
      DockerExecutable dockerExecutable,
      Docker docker,
      ShutdownStrategy shutdownStrategy,
      DockerCompose dockerCompose,
      Cluster containers,
      int retryAttempts,
      boolean removeConflictingContainersOnStartup,
      boolean pullOnStartup,
      ReadableDuration nativeServiceHealthCheckTimeout,
      LogCollector logCollector) {
    this.files = files;
    this.clusterWaits = clusterWaits;
    this.machine = machine;
    this.projectName = projectName;
    this.dockerComposeExecutable = dockerComposeExecutable;
    this.dockerExecutable = dockerExecutable;
    this.docker = docker;
    this.shutdownStrategy = shutdownStrategy;
    this.dockerCompose = dockerCompose;
    this.containers = containers;
    this.retryAttempts = retryAttempts;
    this.removeConflictingContainersOnStartup = removeConflictingContainersOnStartup;
    this.pullOnStartup = pullOnStartup;
    this.nativeServiceHealthCheckTimeout = nativeServiceHealthCheckTimeout;
    this.logCollector = logCollector;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private DockerMachine machine;
    private int machineBuildStage;

    DockerMachine machine() {
      if (machineBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (machineBuildStage == STAGE_UNINITIALIZED) {
        machineBuildStage = STAGE_INITIALIZING;
        this.machine = Preconditions.checkNotNull(ImmutableDockerComposeRule.super.machine(), "machine");
        machineBuildStage = STAGE_INITIALIZED;
      }
      return this.machine;
    }

    void machine(DockerMachine machine) {
      this.machine = machine;
      machineBuildStage = STAGE_INITIALIZED;
    }
    private ProjectName projectName;
    private int projectNameBuildStage;

    ProjectName projectName() {
      if (projectNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (projectNameBuildStage == STAGE_UNINITIALIZED) {
        projectNameBuildStage = STAGE_INITIALIZING;
        this.projectName = Preconditions.checkNotNull(ImmutableDockerComposeRule.super.projectName(), "projectName");
        projectNameBuildStage = STAGE_INITIALIZED;
      }
      return this.projectName;
    }

    void projectName(ProjectName projectName) {
      this.projectName = projectName;
      projectNameBuildStage = STAGE_INITIALIZED;
    }
    private DockerComposeExecutable dockerComposeExecutable;
    private int dockerComposeExecutableBuildStage;

    DockerComposeExecutable dockerComposeExecutable() {
      if (dockerComposeExecutableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dockerComposeExecutableBuildStage == STAGE_UNINITIALIZED) {
        dockerComposeExecutableBuildStage = STAGE_INITIALIZING;
        this.dockerComposeExecutable = Preconditions.checkNotNull(ImmutableDockerComposeRule.super.dockerComposeExecutable(), "dockerComposeExecutable");
        dockerComposeExecutableBuildStage = STAGE_INITIALIZED;
      }
      return this.dockerComposeExecutable;
    }

    void dockerComposeExecutable(DockerComposeExecutable dockerComposeExecutable) {
      this.dockerComposeExecutable = dockerComposeExecutable;
      dockerComposeExecutableBuildStage = STAGE_INITIALIZED;
    }
    private DockerExecutable dockerExecutable;
    private int dockerExecutableBuildStage;

    DockerExecutable dockerExecutable() {
      if (dockerExecutableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dockerExecutableBuildStage == STAGE_UNINITIALIZED) {
        dockerExecutableBuildStage = STAGE_INITIALIZING;
        this.dockerExecutable = Preconditions.checkNotNull(ImmutableDockerComposeRule.super.dockerExecutable(), "dockerExecutable");
        dockerExecutableBuildStage = STAGE_INITIALIZED;
      }
      return this.dockerExecutable;
    }

    void dockerExecutable(DockerExecutable dockerExecutable) {
      this.dockerExecutable = dockerExecutable;
      dockerExecutableBuildStage = STAGE_INITIALIZED;
    }
    private Docker docker;
    private int dockerBuildStage;

    Docker docker() {
      if (dockerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dockerBuildStage == STAGE_UNINITIALIZED) {
        dockerBuildStage = STAGE_INITIALIZING;
        this.docker = Preconditions.checkNotNull(ImmutableDockerComposeRule.super.docker(), "docker");
        dockerBuildStage = STAGE_INITIALIZED;
      }
      return this.docker;
    }

    void docker(Docker docker) {
      this.docker = docker;
      dockerBuildStage = STAGE_INITIALIZED;
    }
    private ShutdownStrategy shutdownStrategy;
    private int shutdownStrategyBuildStage;

    ShutdownStrategy shutdownStrategy() {
      if (shutdownStrategyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (shutdownStrategyBuildStage == STAGE_UNINITIALIZED) {
        shutdownStrategyBuildStage = STAGE_INITIALIZING;
        this.shutdownStrategy = Preconditions.checkNotNull(ImmutableDockerComposeRule.super.shutdownStrategy(), "shutdownStrategy");
        shutdownStrategyBuildStage = STAGE_INITIALIZED;
      }
      return this.shutdownStrategy;
    }

    void shutdownStrategy(ShutdownStrategy shutdownStrategy) {
      this.shutdownStrategy = shutdownStrategy;
      shutdownStrategyBuildStage = STAGE_INITIALIZED;
    }
    private DockerCompose dockerCompose;
    private int dockerComposeBuildStage;

    DockerCompose dockerCompose() {
      if (dockerComposeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dockerComposeBuildStage == STAGE_UNINITIALIZED) {
        dockerComposeBuildStage = STAGE_INITIALIZING;
        this.dockerCompose = Preconditions.checkNotNull(ImmutableDockerComposeRule.super.dockerCompose(), "dockerCompose");
        dockerComposeBuildStage = STAGE_INITIALIZED;
      }
      return this.dockerCompose;
    }

    void dockerCompose(DockerCompose dockerCompose) {
      this.dockerCompose = dockerCompose;
      dockerComposeBuildStage = STAGE_INITIALIZED;
    }
    private Cluster containers;
    private int containersBuildStage;

    Cluster containers() {
      if (containersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (containersBuildStage == STAGE_UNINITIALIZED) {
        containersBuildStage = STAGE_INITIALIZING;
        this.containers = Preconditions.checkNotNull(ImmutableDockerComposeRule.super.containers(), "containers");
        containersBuildStage = STAGE_INITIALIZED;
      }
      return this.containers;
    }

    void containers(Cluster containers) {
      this.containers = containers;
      containersBuildStage = STAGE_INITIALIZED;
    }
    private int retryAttempts;
    private int retryAttemptsBuildStage;

    int retryAttempts() {
      if (retryAttemptsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (retryAttemptsBuildStage == STAGE_UNINITIALIZED) {
        retryAttemptsBuildStage = STAGE_INITIALIZING;
        this.retryAttempts = ImmutableDockerComposeRule.super.retryAttempts();
        retryAttemptsBuildStage = STAGE_INITIALIZED;
      }
      return this.retryAttempts;
    }

    void retryAttempts(int retryAttempts) {
      this.retryAttempts = retryAttempts;
      retryAttemptsBuildStage = STAGE_INITIALIZED;
    }
    private boolean removeConflictingContainersOnStartup;
    private int removeConflictingContainersOnStartupBuildStage;

    boolean removeConflictingContainersOnStartup() {
      if (removeConflictingContainersOnStartupBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (removeConflictingContainersOnStartupBuildStage == STAGE_UNINITIALIZED) {
        removeConflictingContainersOnStartupBuildStage = STAGE_INITIALIZING;
        this.removeConflictingContainersOnStartup = ImmutableDockerComposeRule.super.removeConflictingContainersOnStartup();
        removeConflictingContainersOnStartupBuildStage = STAGE_INITIALIZED;
      }
      return this.removeConflictingContainersOnStartup;
    }

    void removeConflictingContainersOnStartup(boolean removeConflictingContainersOnStartup) {
      this.removeConflictingContainersOnStartup = removeConflictingContainersOnStartup;
      removeConflictingContainersOnStartupBuildStage = STAGE_INITIALIZED;
    }
    private boolean pullOnStartup;
    private int pullOnStartupBuildStage;

    boolean pullOnStartup() {
      if (pullOnStartupBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pullOnStartupBuildStage == STAGE_UNINITIALIZED) {
        pullOnStartupBuildStage = STAGE_INITIALIZING;
        this.pullOnStartup = ImmutableDockerComposeRule.super.pullOnStartup();
        pullOnStartupBuildStage = STAGE_INITIALIZED;
      }
      return this.pullOnStartup;
    }

    void pullOnStartup(boolean pullOnStartup) {
      this.pullOnStartup = pullOnStartup;
      pullOnStartupBuildStage = STAGE_INITIALIZED;
    }
    private ReadableDuration nativeServiceHealthCheckTimeout;
    private int nativeServiceHealthCheckTimeoutBuildStage;

    ReadableDuration nativeServiceHealthCheckTimeout() {
      if (nativeServiceHealthCheckTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nativeServiceHealthCheckTimeoutBuildStage == STAGE_UNINITIALIZED) {
        nativeServiceHealthCheckTimeoutBuildStage = STAGE_INITIALIZING;
        this.nativeServiceHealthCheckTimeout = Preconditions.checkNotNull(ImmutableDockerComposeRule.super.nativeServiceHealthCheckTimeout(), "nativeServiceHealthCheckTimeout");
        nativeServiceHealthCheckTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.nativeServiceHealthCheckTimeout;
    }

    void nativeServiceHealthCheckTimeout(ReadableDuration nativeServiceHealthCheckTimeout) {
      this.nativeServiceHealthCheckTimeout = nativeServiceHealthCheckTimeout;
      nativeServiceHealthCheckTimeoutBuildStage = STAGE_INITIALIZED;
    }
    private LogCollector logCollector;
    private int logCollectorBuildStage;

    LogCollector logCollector() {
      if (logCollectorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (logCollectorBuildStage == STAGE_UNINITIALIZED) {
        logCollectorBuildStage = STAGE_INITIALIZING;
        this.logCollector = Preconditions.checkNotNull(ImmutableDockerComposeRule.super.logCollector(), "logCollector");
        logCollectorBuildStage = STAGE_INITIALIZED;
      }
      return this.logCollector;
    }

    void logCollector(LogCollector logCollector) {
      this.logCollector = logCollector;
      logCollectorBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = Lists.newArrayList();
      if (machineBuildStage == STAGE_INITIALIZING) attributes.add("machine");
      if (projectNameBuildStage == STAGE_INITIALIZING) attributes.add("projectName");
      if (dockerComposeExecutableBuildStage == STAGE_INITIALIZING) attributes.add("dockerComposeExecutable");
      if (dockerExecutableBuildStage == STAGE_INITIALIZING) attributes.add("dockerExecutable");
      if (dockerBuildStage == STAGE_INITIALIZING) attributes.add("docker");
      if (shutdownStrategyBuildStage == STAGE_INITIALIZING) attributes.add("shutdownStrategy");
      if (dockerComposeBuildStage == STAGE_INITIALIZING) attributes.add("dockerCompose");
      if (containersBuildStage == STAGE_INITIALIZING) attributes.add("containers");
      if (retryAttemptsBuildStage == STAGE_INITIALIZING) attributes.add("retryAttempts");
      if (removeConflictingContainersOnStartupBuildStage == STAGE_INITIALIZING) attributes.add("removeConflictingContainersOnStartup");
      if (pullOnStartupBuildStage == STAGE_INITIALIZING) attributes.add("pullOnStartup");
      if (nativeServiceHealthCheckTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("nativeServiceHealthCheckTimeout");
      if (logCollectorBuildStage == STAGE_INITIALIZING) attributes.add("logCollector");
      return "Cannot build DockerComposeRule, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public DockerComposeFiles files() {
    return files;
  }

  /**
   * @return The value of the {@code clusterWaits} attribute
   */
  @Override
  protected ImmutableList<ClusterWait> clusterWaits() {
    return clusterWaits;
  }

  /**
   * @return The value of the {@code machine} attribute
   */
  @Override
  public DockerMachine machine() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.machine()
        : this.machine;
  }

  /**
   * @return The value of the {@code projectName} attribute
   */
  @Override
  public ProjectName projectName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.projectName()
        : this.projectName;
  }

  /**
   * @return The value of the {@code dockerComposeExecutable} attribute
   */
  @Override
  public DockerComposeExecutable dockerComposeExecutable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.dockerComposeExecutable()
        : this.dockerComposeExecutable;
  }

  /**
   * @return The value of the {@code dockerExecutable} attribute
   */
  @Override
  public DockerExecutable dockerExecutable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.dockerExecutable()
        : this.dockerExecutable;
  }

  /**
   * @return The value of the {@code docker} attribute
   */
  @Override
  public Docker docker() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.docker()
        : this.docker;
  }

  /**
   * @return The value of the {@code shutdownStrategy} attribute
   */
  @Override
  public ShutdownStrategy shutdownStrategy() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.shutdownStrategy()
        : this.shutdownStrategy;
  }

  /**
   * @return The value of the {@code dockerCompose} attribute
   */
  @Override
  public DockerCompose dockerCompose() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.dockerCompose()
        : this.dockerCompose;
  }

  /**
   * @return The value of the {@code containers} attribute
   */
  @Override
  public Cluster containers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.containers()
        : this.containers;
  }

  /**
   * @return The value of the {@code retryAttempts} attribute
   */
  @Override
  protected int retryAttempts() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.retryAttempts()
        : this.retryAttempts;
  }

  /**
   * @return The value of the {@code removeConflictingContainersOnStartup} attribute
   */
  @Override
  protected boolean removeConflictingContainersOnStartup() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.removeConflictingContainersOnStartup()
        : this.removeConflictingContainersOnStartup;
  }

  /**
   * @return The value of the {@code pullOnStartup} attribute
   */
  @Override
  protected boolean pullOnStartup() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pullOnStartup()
        : this.pullOnStartup;
  }

  /**
   * @return The value of the {@code nativeServiceHealthCheckTimeout} attribute
   */
  @Override
  protected ReadableDuration nativeServiceHealthCheckTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.nativeServiceHealthCheckTimeout()
        : this.nativeServiceHealthCheckTimeout;
  }

  /**
   * @return The value of the {@code logCollector} attribute
   */
  @Override
  protected LogCollector logCollector() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.logCollector()
        : this.logCollector;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#files() files} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for files
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withFiles(DockerComposeFiles value) {
    if (this.files == value) return this;
    DockerComposeFiles newValue = Preconditions.checkNotNull(value, "files");
    return new ImmutableDockerComposeRule(
        newValue,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DockerComposeRule#clusterWaits() clusterWaits}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDockerComposeRule withClusterWaits(ClusterWait... elements) {
    ImmutableList<ClusterWait> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDockerComposeRule(
        this.files,
        newValue,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DockerComposeRule#clusterWaits() clusterWaits}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of clusterWaits elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDockerComposeRule withClusterWaits(Iterable<? extends ClusterWait> elements) {
    if (this.clusterWaits == elements) return this;
    ImmutableList<ClusterWait> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDockerComposeRule(
        this.files,
        newValue,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#machine() machine} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for machine
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withMachine(DockerMachine value) {
    if (this.machine == value) return this;
    DockerMachine newValue = Preconditions.checkNotNull(value, "machine");
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        newValue,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#projectName() projectName} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for projectName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withProjectName(ProjectName value) {
    if (this.projectName == value) return this;
    ProjectName newValue = Preconditions.checkNotNull(value, "projectName");
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        newValue,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#dockerComposeExecutable() dockerComposeExecutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dockerComposeExecutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withDockerComposeExecutable(DockerComposeExecutable value) {
    if (this.dockerComposeExecutable == value) return this;
    DockerComposeExecutable newValue = Preconditions.checkNotNull(value, "dockerComposeExecutable");
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        newValue,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#dockerExecutable() dockerExecutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dockerExecutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withDockerExecutable(DockerExecutable value) {
    if (this.dockerExecutable == value) return this;
    DockerExecutable newValue = Preconditions.checkNotNull(value, "dockerExecutable");
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        newValue,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#docker() docker} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for docker
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withDocker(Docker value) {
    if (this.docker == value) return this;
    Docker newValue = Preconditions.checkNotNull(value, "docker");
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        newValue,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#shutdownStrategy() shutdownStrategy} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for shutdownStrategy
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withShutdownStrategy(ShutdownStrategy value) {
    if (this.shutdownStrategy == value) return this;
    ShutdownStrategy newValue = Preconditions.checkNotNull(value, "shutdownStrategy");
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        newValue,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#dockerCompose() dockerCompose} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dockerCompose
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withDockerCompose(DockerCompose value) {
    if (this.dockerCompose == value) return this;
    DockerCompose newValue = Preconditions.checkNotNull(value, "dockerCompose");
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        newValue,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#containers() containers} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containers
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withContainers(Cluster value) {
    if (this.containers == value) return this;
    Cluster newValue = Preconditions.checkNotNull(value, "containers");
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        newValue,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#retryAttempts() retryAttempts} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for retryAttempts
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withRetryAttempts(int value) {
    if (this.retryAttempts == value) return this;
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        value,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#removeConflictingContainersOnStartup() removeConflictingContainersOnStartup} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for removeConflictingContainersOnStartup
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withRemoveConflictingContainersOnStartup(boolean value) {
    if (this.removeConflictingContainersOnStartup == value) return this;
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        value,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#pullOnStartup() pullOnStartup} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pullOnStartup
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withPullOnStartup(boolean value) {
    if (this.pullOnStartup == value) return this;
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        value,
        this.nativeServiceHealthCheckTimeout,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#nativeServiceHealthCheckTimeout() nativeServiceHealthCheckTimeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nativeServiceHealthCheckTimeout
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withNativeServiceHealthCheckTimeout(ReadableDuration value) {
    if (this.nativeServiceHealthCheckTimeout == value) return this;
    ReadableDuration newValue = Preconditions.checkNotNull(value, "nativeServiceHealthCheckTimeout");
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        newValue,
        this.logCollector);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerComposeRule#logCollector() logCollector} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for logCollector
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerComposeRule withLogCollector(LogCollector value) {
    if (this.logCollector == value) return this;
    LogCollector newValue = Preconditions.checkNotNull(value, "logCollector");
    return new ImmutableDockerComposeRule(
        this.files,
        this.clusterWaits,
        this.machine,
        this.projectName,
        this.dockerComposeExecutable,
        this.dockerExecutable,
        this.docker,
        this.shutdownStrategy,
        this.dockerCompose,
        this.containers,
        this.retryAttempts,
        this.removeConflictingContainersOnStartup,
        this.pullOnStartup,
        this.nativeServiceHealthCheckTimeout,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDockerComposeRule} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDockerComposeRule
        && equalTo((ImmutableDockerComposeRule) another);
  }

  private boolean equalTo(ImmutableDockerComposeRule another) {
    return files.equals(another.files)
        && clusterWaits.equals(another.clusterWaits)
        && machine.equals(another.machine)
        && projectName.equals(another.projectName)
        && dockerComposeExecutable.equals(another.dockerComposeExecutable)
        && dockerExecutable.equals(another.dockerExecutable)
        && docker.equals(another.docker)
        && shutdownStrategy.equals(another.shutdownStrategy)
        && dockerCompose.equals(another.dockerCompose)
        && containers.equals(another.containers)
        && retryAttempts == another.retryAttempts
        && removeConflictingContainersOnStartup == another.removeConflictingContainersOnStartup
        && pullOnStartup == another.pullOnStartup
        && nativeServiceHealthCheckTimeout.equals(another.nativeServiceHealthCheckTimeout)
        && logCollector.equals(another.logCollector);
  }

  /**
   * Computes a hash code from attributes: {@code files}, {@code clusterWaits}, {@code machine}, {@code projectName}, {@code dockerComposeExecutable}, {@code dockerExecutable}, {@code docker}, {@code shutdownStrategy}, {@code dockerCompose}, {@code containers}, {@code retryAttempts}, {@code removeConflictingContainersOnStartup}, {@code pullOnStartup}, {@code nativeServiceHealthCheckTimeout}, {@code logCollector}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + files.hashCode();
    h += (h << 5) + clusterWaits.hashCode();
    h += (h << 5) + machine.hashCode();
    h += (h << 5) + projectName.hashCode();
    h += (h << 5) + dockerComposeExecutable.hashCode();
    h += (h << 5) + dockerExecutable.hashCode();
    h += (h << 5) + docker.hashCode();
    h += (h << 5) + shutdownStrategy.hashCode();
    h += (h << 5) + dockerCompose.hashCode();
    h += (h << 5) + containers.hashCode();
    h += (h << 5) + retryAttempts;
    h += (h << 5) + Booleans.hashCode(removeConflictingContainersOnStartup);
    h += (h << 5) + Booleans.hashCode(pullOnStartup);
    h += (h << 5) + nativeServiceHealthCheckTimeout.hashCode();
    h += (h << 5) + logCollector.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DockerComposeRule} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DockerComposeRule")
        .omitNullValues()
        .add("files", files)
        .add("clusterWaits", clusterWaits)
        .add("machine", machine)
        .add("projectName", projectName)
        .add("dockerComposeExecutable", dockerComposeExecutable)
        .add("dockerExecutable", dockerExecutable)
        .add("docker", docker)
        .add("shutdownStrategy", shutdownStrategy)
        .add("dockerCompose", dockerCompose)
        .add("containers", containers)
        .add("retryAttempts", retryAttempts)
        .add("removeConflictingContainersOnStartup", removeConflictingContainersOnStartup)
        .add("pullOnStartup", pullOnStartup)
        .add("nativeServiceHealthCheckTimeout", nativeServiceHealthCheckTimeout)
        .add("logCollector", logCollector)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DockerComposeRule} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DockerComposeRule instance
   */
  public static ImmutableDockerComposeRule copyOf(DockerComposeRule instance) {
    if (instance instanceof ImmutableDockerComposeRule) {
      return (ImmutableDockerComposeRule) instance;
    }
    return new DockerComposeRule.Builder()
        .files(instance.files())
        .addAllClusterWaits(instance.clusterWaits())
        .machine(instance.machine())
        .projectName(instance.projectName())
        .dockerComposeExecutable(instance.dockerComposeExecutable())
        .dockerExecutable(instance.dockerExecutable())
        .docker(instance.docker())
        .shutdownStrategy(instance.shutdownStrategy())
        .dockerCompose(instance.dockerCompose())
        .containers(instance.containers())
        .retryAttempts(instance.retryAttempts())
        .removeConflictingContainersOnStartup(instance.removeConflictingContainersOnStartup())
        .pullOnStartup(instance.pullOnStartup())
        .nativeServiceHealthCheckTimeout(instance.nativeServiceHealthCheckTimeout())
        .logCollector(instance.logCollector())
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableDockerComposeRule ImmutableDockerComposeRule}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static class Builder {
    private static final long INIT_BIT_FILES = 0x1L;
    private static final long OPT_BIT_MACHINE = 0x1L;
    private static final long OPT_BIT_PROJECT_NAME = 0x2L;
    private static final long OPT_BIT_DOCKER_COMPOSE_EXECUTABLE = 0x4L;
    private static final long OPT_BIT_DOCKER_EXECUTABLE = 0x8L;
    private static final long OPT_BIT_DOCKER = 0x10L;
    private static final long OPT_BIT_SHUTDOWN_STRATEGY = 0x20L;
    private static final long OPT_BIT_DOCKER_COMPOSE = 0x40L;
    private static final long OPT_BIT_CONTAINERS = 0x80L;
    private static final long OPT_BIT_RETRY_ATTEMPTS = 0x100L;
    private static final long OPT_BIT_REMOVE_CONFLICTING_CONTAINERS_ON_STARTUP = 0x200L;
    private static final long OPT_BIT_PULL_ON_STARTUP = 0x400L;
    private static final long OPT_BIT_NATIVE_SERVICE_HEALTH_CHECK_TIMEOUT = 0x800L;
    private static final long OPT_BIT_LOG_COLLECTOR = 0x1000L;
    private long initBits = 0x1L;
    private long optBits;

    private DockerComposeFiles files;
    private ImmutableList.Builder<ClusterWait> clusterWaits = ImmutableList.builder();
    private DockerMachine machine;
    private ProjectName projectName;
    private DockerComposeExecutable dockerComposeExecutable;
    private DockerExecutable dockerExecutable;
    private Docker docker;
    private ShutdownStrategy shutdownStrategy;
    private DockerCompose dockerCompose;
    private Cluster containers;
    private int retryAttempts;
    private boolean removeConflictingContainersOnStartup;
    private boolean pullOnStartup;
    private ReadableDuration nativeServiceHealthCheckTimeout;
    private LogCollector logCollector;

    /**
     * Creates a builder for {@link ImmutableDockerComposeRule ImmutableDockerComposeRule} instances.
     */
    public Builder() {
      if (!(this instanceof DockerComposeRule.Builder)) {
        throw new UnsupportedOperationException("Use: new DockerComposeRule.Builder()");
      }
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#files() files} attribute.
     * @param files The value for files 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder files(DockerComposeFiles files) {
      checkNotIsSet(filesIsSet(), "files");
      this.files = Preconditions.checkNotNull(files, "files");
      initBits &= ~INIT_BIT_FILES;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Adds one element to {@link DockerComposeRule#clusterWaits() clusterWaits} list.
     * @param element A clusterWaits element
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder addClusterWait(ClusterWait element) {
      this.clusterWaits.add(element);
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Adds elements to {@link DockerComposeRule#clusterWaits() clusterWaits} list.
     * @param elements An array of clusterWaits elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder addClusterWait(ClusterWait... elements) {
      this.clusterWaits.add(elements);
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Adds elements to {@link DockerComposeRule#clusterWaits() clusterWaits} list.
     * @param elements An iterable of clusterWaits elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder addAllClusterWaits(Iterable<? extends ClusterWait> elements) {
      this.clusterWaits.addAll(elements);
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#machine() machine} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#machine() machine}.</em>
     * @param machine The value for machine 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder machine(DockerMachine machine) {
      checkNotIsSet(machineIsSet(), "machine");
      this.machine = Preconditions.checkNotNull(machine, "machine");
      optBits |= OPT_BIT_MACHINE;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#projectName() projectName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#projectName() projectName}.</em>
     * @param projectName The value for projectName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder projectName(ProjectName projectName) {
      checkNotIsSet(projectNameIsSet(), "projectName");
      this.projectName = Preconditions.checkNotNull(projectName, "projectName");
      optBits |= OPT_BIT_PROJECT_NAME;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#dockerComposeExecutable() dockerComposeExecutable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#dockerComposeExecutable() dockerComposeExecutable}.</em>
     * @param dockerComposeExecutable The value for dockerComposeExecutable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder dockerComposeExecutable(DockerComposeExecutable dockerComposeExecutable) {
      checkNotIsSet(dockerComposeExecutableIsSet(), "dockerComposeExecutable");
      this.dockerComposeExecutable = Preconditions.checkNotNull(dockerComposeExecutable, "dockerComposeExecutable");
      optBits |= OPT_BIT_DOCKER_COMPOSE_EXECUTABLE;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#dockerExecutable() dockerExecutable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#dockerExecutable() dockerExecutable}.</em>
     * @param dockerExecutable The value for dockerExecutable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder dockerExecutable(DockerExecutable dockerExecutable) {
      checkNotIsSet(dockerExecutableIsSet(), "dockerExecutable");
      this.dockerExecutable = Preconditions.checkNotNull(dockerExecutable, "dockerExecutable");
      optBits |= OPT_BIT_DOCKER_EXECUTABLE;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#docker() docker} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#docker() docker}.</em>
     * @param docker The value for docker 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder docker(Docker docker) {
      checkNotIsSet(dockerIsSet(), "docker");
      this.docker = Preconditions.checkNotNull(docker, "docker");
      optBits |= OPT_BIT_DOCKER;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#shutdownStrategy() shutdownStrategy} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#shutdownStrategy() shutdownStrategy}.</em>
     * @param shutdownStrategy The value for shutdownStrategy 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder shutdownStrategy(ShutdownStrategy shutdownStrategy) {
      checkNotIsSet(shutdownStrategyIsSet(), "shutdownStrategy");
      this.shutdownStrategy = Preconditions.checkNotNull(shutdownStrategy, "shutdownStrategy");
      optBits |= OPT_BIT_SHUTDOWN_STRATEGY;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#dockerCompose() dockerCompose} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#dockerCompose() dockerCompose}.</em>
     * @param dockerCompose The value for dockerCompose 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder dockerCompose(DockerCompose dockerCompose) {
      checkNotIsSet(dockerComposeIsSet(), "dockerCompose");
      this.dockerCompose = Preconditions.checkNotNull(dockerCompose, "dockerCompose");
      optBits |= OPT_BIT_DOCKER_COMPOSE;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#containers() containers} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#containers() containers}.</em>
     * @param containers The value for containers 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder containers(Cluster containers) {
      checkNotIsSet(containersIsSet(), "containers");
      this.containers = Preconditions.checkNotNull(containers, "containers");
      optBits |= OPT_BIT_CONTAINERS;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#retryAttempts() retryAttempts} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#retryAttempts() retryAttempts}.</em>
     * @param retryAttempts The value for retryAttempts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder retryAttempts(int retryAttempts) {
      checkNotIsSet(retryAttemptsIsSet(), "retryAttempts");
      this.retryAttempts = retryAttempts;
      optBits |= OPT_BIT_RETRY_ATTEMPTS;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#removeConflictingContainersOnStartup() removeConflictingContainersOnStartup} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#removeConflictingContainersOnStartup() removeConflictingContainersOnStartup}.</em>
     * @param removeConflictingContainersOnStartup The value for removeConflictingContainersOnStartup 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder removeConflictingContainersOnStartup(boolean removeConflictingContainersOnStartup) {
      checkNotIsSet(removeConflictingContainersOnStartupIsSet(), "removeConflictingContainersOnStartup");
      this.removeConflictingContainersOnStartup = removeConflictingContainersOnStartup;
      optBits |= OPT_BIT_REMOVE_CONFLICTING_CONTAINERS_ON_STARTUP;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#pullOnStartup() pullOnStartup} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#pullOnStartup() pullOnStartup}.</em>
     * @param pullOnStartup The value for pullOnStartup 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder pullOnStartup(boolean pullOnStartup) {
      checkNotIsSet(pullOnStartupIsSet(), "pullOnStartup");
      this.pullOnStartup = pullOnStartup;
      optBits |= OPT_BIT_PULL_ON_STARTUP;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#nativeServiceHealthCheckTimeout() nativeServiceHealthCheckTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#nativeServiceHealthCheckTimeout() nativeServiceHealthCheckTimeout}.</em>
     * @param nativeServiceHealthCheckTimeout The value for nativeServiceHealthCheckTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder nativeServiceHealthCheckTimeout(ReadableDuration nativeServiceHealthCheckTimeout) {
      checkNotIsSet(nativeServiceHealthCheckTimeoutIsSet(), "nativeServiceHealthCheckTimeout");
      this.nativeServiceHealthCheckTimeout = Preconditions.checkNotNull(nativeServiceHealthCheckTimeout, "nativeServiceHealthCheckTimeout");
      optBits |= OPT_BIT_NATIVE_SERVICE_HEALTH_CHECK_TIMEOUT;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerComposeRule#logCollector() logCollector} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerComposeRule#logCollector() logCollector}.</em>
     * @param logCollector The value for logCollector 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerComposeRule.Builder logCollector(LogCollector logCollector) {
      checkNotIsSet(logCollectorIsSet(), "logCollector");
      this.logCollector = Preconditions.checkNotNull(logCollector, "logCollector");
      optBits |= OPT_BIT_LOG_COLLECTOR;
      return (DockerComposeRule.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableDockerComposeRule ImmutableDockerComposeRule}.
     * @return An immutable instance of DockerComposeRule
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDockerComposeRule build() {
      checkRequiredAttributes();
      return new ImmutableDockerComposeRule(this);
    }

    private boolean machineIsSet() {
      return (optBits & OPT_BIT_MACHINE) != 0;
    }

    private boolean projectNameIsSet() {
      return (optBits & OPT_BIT_PROJECT_NAME) != 0;
    }

    private boolean dockerComposeExecutableIsSet() {
      return (optBits & OPT_BIT_DOCKER_COMPOSE_EXECUTABLE) != 0;
    }

    private boolean dockerExecutableIsSet() {
      return (optBits & OPT_BIT_DOCKER_EXECUTABLE) != 0;
    }

    private boolean dockerIsSet() {
      return (optBits & OPT_BIT_DOCKER) != 0;
    }

    private boolean shutdownStrategyIsSet() {
      return (optBits & OPT_BIT_SHUTDOWN_STRATEGY) != 0;
    }

    private boolean dockerComposeIsSet() {
      return (optBits & OPT_BIT_DOCKER_COMPOSE) != 0;
    }

    private boolean containersIsSet() {
      return (optBits & OPT_BIT_CONTAINERS) != 0;
    }

    private boolean retryAttemptsIsSet() {
      return (optBits & OPT_BIT_RETRY_ATTEMPTS) != 0;
    }

    private boolean removeConflictingContainersOnStartupIsSet() {
      return (optBits & OPT_BIT_REMOVE_CONFLICTING_CONTAINERS_ON_STARTUP) != 0;
    }

    private boolean pullOnStartupIsSet() {
      return (optBits & OPT_BIT_PULL_ON_STARTUP) != 0;
    }

    private boolean nativeServiceHealthCheckTimeoutIsSet() {
      return (optBits & OPT_BIT_NATIVE_SERVICE_HEALTH_CHECK_TIMEOUT) != 0;
    }

    private boolean logCollectorIsSet() {
      return (optBits & OPT_BIT_LOG_COLLECTOR) != 0;
    }

    private boolean filesIsSet() {
      return (initBits & INIT_BIT_FILES) == 0;
    }

    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of DockerComposeRule is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if (!filesIsSet()) attributes.add("files");
      return "Cannot build DockerComposeRule, some of required attributes are not set " + attributes;
    }
  }
}
