/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.serialization;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

final class LenientLongModule
extends SimpleModule {
    LenientLongModule() {
        super("lenient long");
        this.addDeserializer(Long.TYPE, (JsonDeserializer)new LongAsStringDeserializer()).addDeserializer(Long.class, (JsonDeserializer)new LongAsStringDeserializer());
    }

    private static final class LongAsStringDeserializer
    extends StdDeserializer<Long> {
        private LongAsStringDeserializer() {
            super(Long.TYPE);
        }

        public Long deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            switch (jsonParser.currentToken()) {
                case VALUE_NUMBER_INT: {
                    return jsonParser.getLongValue();
                }
                case VALUE_STRING: {
                    return LongAsStringDeserializer.parseLong(jsonParser);
                }
                case VALUE_NULL: {
                    return null;
                }
            }
            throw new IOException("Expected a long value");
        }

        public boolean isCachable() {
            return true;
        }

        private static Long parseLong(JsonParser jsonParser) throws IOException {
            try {
                return Long.valueOf(jsonParser.getValueAsString());
            }
            catch (NumberFormatException e) {
                throw new JsonParseException(jsonParser, "not a valid long value", (Throwable)e);
            }
        }
    }
}

