/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.client.config;

import com.google.common.net.HostAndPort;
import com.palantir.conjure.java.api.config.service.BasicCredentials;
import com.palantir.conjure.java.api.config.service.UserAgent;
import com.palantir.conjure.java.client.config.HostEventsSink;
import com.palantir.conjure.java.client.config.ImmutableClientConfiguration;
import com.palantir.conjure.java.client.config.ImmutablesStyle;
import com.palantir.conjure.java.client.config.NodeSelectionStrategy;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.net.ProxySelector;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.immutables.value.Value;

@Value.Immutable
@ImmutablesStyle
public interface ClientConfiguration {
    public SSLSocketFactory sslSocketFactory();

    public X509TrustManager trustManager();

    public List<String> uris();

    public Duration connectTimeout();

    public Duration readTimeout();

    public Duration writeTimeout();

    public boolean enableGcmCipherSuites();

    public Optional<Boolean> enableHttp2();

    public boolean fallbackToCommonNameVerification();

    public ProxySelector proxy();

    public Optional<BasicCredentials> proxyCredentials();

    public Optional<HostAndPort> meshProxy();

    public int maxNumRetries();

    public NodeSelectionStrategy nodeSelectionStrategy();

    public Duration failedUrlCooldown();

    public Duration backoffSlotSize();

    public ClientQoS clientQoS();

    public ServerQoS serverQoS();

    public RetryOnTimeout retryOnTimeout();

    public RetryOnSocketException retryOnSocketException();

    public TaggedMetricRegistry taggedMetricRegistry();

    public Optional<UserAgent> userAgent();

    public Optional<HostEventsSink> hostEventsSink();

    @Value.Check
    default public void check() {
        if (this.meshProxy().isPresent()) {
            Preconditions.checkArgument((this.maxNumRetries() == 0 ? 1 : 0) != 0, (String)"If meshProxy is configured then maxNumRetries must be 0");
            Preconditions.checkArgument((this.uris().size() == 1 ? 1 : 0) != 0, (String)"If meshProxy is configured then uris must contain exactly 1 URI");
        }
        this.checkTimeoutPrecision(this.connectTimeout(), "connectTimeout");
        this.checkTimeoutPrecision(this.readTimeout(), "readTimeout");
        this.checkTimeoutPrecision(this.writeTimeout(), "writeTimeout");
        Preconditions.checkArgument((!this.failedUrlCooldown().isNegative() ? 1 : 0) != 0, (String)"failedUrlCooldown may not be negative");
    }

    default public void checkTimeoutPrecision(Duration duration, String timeoutName) {
        Preconditions.checkArgument((boolean)duration.minusMillis(duration.toMillis()).isZero(), (String)"Timeouts with sub-millisecond precision are not supported", (Arg)SafeArg.of((String)"timeoutName", (Object)timeoutName), (Arg)SafeArg.of((String)"duration", (Object)duration), (Arg)UnsafeArg.of((String)"uris", this.uris()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum RetryOnSocketException {
        ENABLED,
        DANGEROUS_DISABLED;

    }

    public static enum RetryOnTimeout {
        DISABLED,
        DANGEROUS_ENABLE_AT_RISK_OF_RETRY_STORMS;

    }

    public static enum ServerQoS {
        AUTOMATIC_RETRY,
        PROPAGATE_429_and_503_TO_CALLER;

    }

    public static enum ClientQoS {
        ENABLED,
        DANGEROUS_DISABLE_SYMPATHETIC_CLIENT_QOS;

    }

    public static class Builder
    extends ImmutableClientConfiguration.Builder {
    }
}

