/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.client.config;

import com.google.common.collect.ImmutableList;

public final class CipherSuites {
    private static final ImmutableList<String> FAST_CIPHER_SUITES = ImmutableList.of((Object)"TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", (Object)"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", (Object)"TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", (Object)"TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", (Object)"TLS_RSA_WITH_AES_128_CBC_SHA256", (Object)"TLS_RSA_WITH_AES_256_CBC_SHA256", (Object)"TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", (Object)"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", (Object)"TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", (Object)"TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", (Object)"TLS_RSA_WITH_AES_256_CBC_SHA", (Object)"TLS_RSA_WITH_AES_128_CBC_SHA", (Object[])new String[]{"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV"});
    private static final ImmutableList<String> GCM_CIPHER_SUITES = ImmutableList.of((Object)"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", (Object)"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", (Object)"TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", (Object)"TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", (Object)"TLS_RSA_WITH_AES_256_GCM_SHA384", (Object)"TLS_RSA_WITH_AES_128_GCM_SHA256");
    private static final ImmutableList<String> ALL_CIPHER_SUITES = ImmutableList.builder().addAll(FAST_CIPHER_SUITES).addAll(GCM_CIPHER_SUITES).build();

    public static String[] fastCipherSuites() {
        return (String[])FAST_CIPHER_SUITES.toArray((Object[])new String[0]);
    }

    public static String[] gcmCipherSuites() {
        return (String[])GCM_CIPHER_SUITES.toArray((Object[])new String[0]);
    }

    public static String[] allCipherSuites() {
        return (String[])ALL_CIPHER_SUITES.toArray((Object[])new String[0]);
    }

    private CipherSuites() {
    }
}

