/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.lib;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class Bytes {
    private final byte[] safe;

    private Bytes(byte[] array) {
        this.safe = array;
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        return ByteBuffer.wrap(this.safe).asReadOnlyBuffer();
    }

    public byte[] asNewByteArray() {
        byte[] unsafe = new byte[this.safe.length];
        System.arraycopy(this.safe, 0, unsafe, 0, this.safe.length);
        return unsafe;
    }

    public void copyTo(byte[] destination, int offset, int length) {
        System.arraycopy(this.safe, 0, destination, offset, length);
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.safe);
    }

    public int size() {
        return this.safe.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.safe);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Bytes && Arrays.equals(this.safe, ((Bytes)obj).safe);
    }

    public String toString() {
        return "Bytes{size: " + this.safe.length + '}';
    }

    public static Bytes from(byte[] array) {
        return Bytes.from(array, 0, array.length);
    }

    public static Bytes from(byte[] array, int offset, int length) {
        byte[] safe = new byte[length];
        System.arraycopy(array, offset, safe, 0, length);
        return new Bytes(safe);
    }

    public static Bytes from(ByteBuffer buffer) {
        ByteBuffer local = buffer.duplicate();
        byte[] safe = new byte[local.remaining()];
        local.get(safe);
        return new Bytes(safe);
    }

    static final class Deserializer
    extends JsonDeserializer<Bytes> {
        Deserializer() {
        }

        public Bytes deserialize(JsonParser parser, DeserializationContext _ctxt) throws IOException {
            return new Bytes(parser.getBinaryValue());
        }
    }

    static final class Serializer
    extends JsonSerializer<Bytes> {
        Serializer() {
        }

        public void serialize(Bytes value, JsonGenerator gen, SerializerProvider _serializer) throws IOException {
            gen.writeBinary(value.safe);
        }
    }
}

