/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.stresstest;

import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.stresstest.workload.OWorkload;

public class OConsoleProgressWriter
extends OSoftThread {
    private final OWorkload workload;
    private String lastResult = null;

    public OConsoleProgressWriter(String name, OWorkload workload) {
        super(name);
        this.workload = workload;
    }

    public void printMessage(String message) {
        System.out.println(message);
    }

    protected void execute() throws Exception {
        String result = this.workload.getPartialResult();
        if (this.lastResult == null || !this.lastResult.equals(result)) {
            System.out.print("\r- Workload in progress " + result);
        }
        this.lastResult = result;
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            this.softShutdown();
        }
    }

    public void sendShutdown() {
        try {
            this.execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.sendShutdown();
    }
}

