/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.plugin.mail;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.script.OScriptInjection;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import com.orientechnologies.orient.server.plugin.OServerPluginConfigurable;
import com.orientechnologies.orient.server.plugin.mail.OMailProfile;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;

public class OMailPlugin
extends OServerPluginAbstract
implements OScriptInjection,
OServerPluginConfigurable {
    private static final String CONFIG_PROFILE_PREFIX = "profile.";
    private static final String CONFIG_MAIL_PREFIX = "mail.";
    private ODocument configuration;
    private Map<String, OMailProfile> profiles = new HashMap<String, OMailProfile>();
    private String configFile = "${ORIENTDB_HOME}/config/mail.json";

    @Override
    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        OrientDBInternal.extract((OrientDB)oServer.getContext()).getScriptManager().registerInjection((OScriptInjection)this);
    }

    public void writeConfiguration() throws IOException {
    }

    public void send(Map<String, Object> iMessage) {
        OLogManager.instance().warn((Object)this, "Mail send is non available in this OrientDB version", new Object[0]);
    }

    public void bind(ScriptEngine engine, Bindings binding, ODatabaseDocument database) {
        binding.put("mail", (Object)this);
    }

    public void unbind(ScriptEngine engine, Bindings binding) {
        binding.put("mail", (Object)null);
    }

    public String getName() {
        return "mail";
    }

    public Set<String> getProfileNames() {
        return this.profiles.keySet();
    }

    public OMailProfile getProfile(String iName) {
        return this.profiles.get(iName);
    }

    public OMailPlugin registerProfile(String iName, OMailProfile iProfile) {
        return this;
    }

    @Override
    public ODocument getConfig() {
        return this.configuration;
    }

    @Override
    public void changeConfig(ODocument document) {
    }
}

