/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.net.URL;
import java.net.URLConnection;

public class OServerCommandPostInstallDatabase
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"POST|installDatabase"};

    public OServerCommandPostInstallDatabase() {
        super("database.create");
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.getUrl(), 1, "Syntax error: installDatabase");
        iRequest.getData().commandInfo = "Import database";
        String url = iRequest.getContent();
        String name = this.getDbName(url);
        if (name != null) {
            if (this.server.getContext().exists(name)) {
                throw new ODatabaseException("Database named '" + name + "' already exists: ");
            }
            URL uri = new URL(url);
            URLConnection conn = uri.openConnection();
            conn.setRequestProperty("User-Agent", "OrientDB-Studio");
            conn.setDefaultUseCaches(false);
            this.server.getDatabases().networkRestore(name, conn.getInputStream(), () -> null);
            ODatabaseDocumentInternal session = this.server.getDatabases().openNoAuthorization(name);
            Throwable throwable = null;
            if (session != null) {
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    session.close();
                }
            }
        } else {
            throw new IllegalArgumentException("Could not find database name");
        }
        iResponse.send(200, "OK", "text/plain", null, null);
        return false;
    }

    protected String getDbName(String url) {
        int idx;
        String name = null;
        if (url != null && (idx = url.lastIndexOf("/")) != -1) {
            name = url.substring(idx + 1).replace(".zip", "");
        }
        return name;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

