/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.delete;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandDeleteClass
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"DELETE|class/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.getUrl(), 3, "Syntax error: class/<database>/<class-name>");
        iRequest.getData().commandInfo = "Delete class";
        iRequest.getData().commandDetail = urlParts[2];
        try (ODatabaseDocumentInternal db = null;){
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getMetadata().getSchema().getClass(urlParts[2]) == null) {
                throw new IllegalArgumentException("Invalid class '" + urlParts[2] + "'");
            }
            db.getMetadata().getSchema().dropClass(urlParts[2]);
            iResponse.send(200, "OK", "text/plain", null, null);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

