/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.network.protocol.http.OChunkedResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public abstract class OHttpResponse {
    public static final String JSON_FORMAT = "type,indent:-1,rid,version,attribSameRow,class,keepTypes,alwaysFetchEmbeddedDocuments,earlyTypes";
    public static final char[] URL_SEPARATOR = new char[]{'/'};
    protected static final Charset utf8 = StandardCharsets.UTF_8;
    private final String httpVersion;
    private final OutputStream out;
    private final OContextConfiguration contextConfiguration;
    private String headers;
    private String[] additionalHeaders;
    private String characterSet;
    private String contentType;
    private String serverInfo;
    private final Map<String, String> headersMap = new HashMap<String, String>();
    private String sessionId;
    private String callbackFunction;
    private String contentEncoding;
    private String staticEncoding;
    private boolean sendStarted = false;
    private String content;
    private int code;
    private boolean keepAlive = true;
    private boolean jsonErrorResponse = true;
    private boolean sameSiteCookie = true;
    private OClientConnection connection;
    private boolean streaming = OGlobalConfiguration.NETWORK_HTTP_STREAMING.getValueAsBoolean();

    public OHttpResponse(OutputStream iOutStream, String iHttpVersion, String[] iAdditionalHeaders, String iResponseCharSet, String iServerInfo, String iSessionId, String iCallbackFunction, boolean iKeepAlive, OClientConnection connection, OContextConfiguration contextConfiguration) {
        this.setStreaming(contextConfiguration.getValueAsBoolean(OGlobalConfiguration.NETWORK_HTTP_STREAMING));
        this.out = iOutStream;
        this.httpVersion = iHttpVersion;
        this.setAdditionalHeaders(iAdditionalHeaders);
        this.setCharacterSet(iResponseCharSet);
        this.setServerInfo(iServerInfo);
        this.setSessionId(iSessionId);
        this.setCallbackFunction(iCallbackFunction);
        this.setKeepAlive(iKeepAlive);
        this.setConnection(connection);
        this.contextConfiguration = contextConfiguration;
    }

    public abstract void send(int var1, String var2, String var3, Object var4, String var5) throws IOException;

    public abstract void writeStatus(int var1, String var2) throws IOException;

    public void writeHeaders(String iContentType) throws IOException {
        this.writeHeaders(iContentType, true);
    }

    public void writeHeaders(String iContentType, boolean iKeepAlive) throws IOException {
        if (this.getHeaders() != null) {
            this.writeLine(this.getHeaders());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.writeLine("Date: " + sdf.format(new Date()));
        this.writeLine("Content-Type: " + iContentType + "; charset=" + this.getCharacterSet());
        this.writeLine("Server: " + this.getServerInfo());
        this.writeLine("Connection: " + (iKeepAlive ? "Keep-Alive" : "close"));
        if (this.getContentEncoding() != null && this.getContentEncoding().length() > 0) {
            this.writeLine("Content-Encoding: " + this.getContentEncoding());
        }
        if (this.getAdditionalHeaders() != null) {
            for (String h : this.getAdditionalHeaders()) {
                this.writeLine(h);
            }
        }
    }

    public void writeLine(String iContent) throws IOException {
        this.writeContent(iContent);
        this.getOut().write(OHttpUtils.EOL);
    }

    public void writeContent(String iContent) throws IOException {
        if (iContent != null) {
            this.getOut().write(iContent.getBytes(utf8));
        }
    }

    public void writeResult(Object result) throws InterruptedException, IOException {
        this.writeResult(result, null, null, null);
    }

    public void writeResult(Object iResult, String iFormat, String iAccept) throws InterruptedException, IOException {
        this.writeResult(iResult, iFormat, iAccept, null);
    }

    public void writeResult(Object iResult, String iFormat, String iAccept, Map<String, Object> iAdditionalProperties) throws InterruptedException, IOException {
        this.writeResult(iResult, iFormat, iAccept, iAdditionalProperties, null);
    }

    public void writeResult(Object iResult, String iFormat, String iAccept, Map<String, Object> iAdditionalProperties, String mode) throws InterruptedException, IOException {
        if (iResult == null) {
            this.send(204, "", "text/plain", null, null);
        } else {
            Iterator<Object> newResult;
            if (iResult instanceof Map) {
                ODocument doc = new ODocument();
                for (Map.Entry entry : ((Map)iResult).entrySet()) {
                    String key = this.keyFromMapObject(entry.getKey());
                    doc.field(key, entry.getValue());
                }
                newResult = Collections.singleton(doc).iterator();
            } else {
                newResult = OMultiValue.isMultiValue((Object)iResult) && OMultiValue.getSize((Object)iResult) > 0 && !(OMultiValue.getFirstValue((Object)iResult) instanceof OIdentifiable) && !(OMultiValue.getFirstValue((Object)iResult) instanceof OResult) ? Collections.singleton(new ODocument().field("value", iResult)).iterator() : (iResult instanceof OIdentifiable ? Collections.singleton(iResult).iterator() : (iResult instanceof Iterable ? ((Iterable)iResult).iterator() : (OMultiValue.isMultiValue((Object)iResult) ? OMultiValue.getMultiValueIterator((Object)iResult) : Collections.singleton(new ODocument().field("value", iResult)).iterator())));
            }
            if (newResult == null) {
                this.send(204, "", "text/plain", null, null);
            } else {
                this.writeRecords(newResult, null, iFormat, iAccept, iAdditionalProperties, mode);
            }
        }
    }

    public void writeRecords(Object iRecords) throws IOException {
        this.writeRecords(iRecords, null, null, null, null);
    }

    public void writeRecords(Object iRecords, String iFetchPlan) throws IOException {
        this.writeRecords(iRecords, iFetchPlan, null, null, null);
    }

    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept) throws IOException {
        this.writeRecords(iRecords, iFetchPlan, iFormat, accept, null);
    }

    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept, Map<String, Object> iAdditionalProperties) throws IOException {
        this.writeRecords(iRecords, iFetchPlan, iFormat, accept, iAdditionalProperties, null);
    }

    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept, Map<String, Object> iAdditionalProperties, String mode) throws IOException {
        if (iRecords == null) {
            this.send(204, "", "text/plain", null, null);
            return;
        }
        int size = OMultiValue.getSize((Object)iRecords);
        final Iterator it = OMultiValue.getMultiValueIterator((Object)iRecords);
        if (accept != null && accept.contains("text/csv")) {
            this.sendStream(200, "OK", "text/csv", "data.csv", new OCallable<Void, OChunkedResponse>(){

                public Void call(OChunkedResponse iArgument) {
                    LinkedHashSet<String> colNames = new LinkedHashSet<String>();
                    ArrayList<Object> records = new ArrayList<Object>();
                    while (it.hasNext()) {
                        ORecord rec;
                        Object r = it.next();
                        if (r instanceof OResult) {
                            OResult result = (OResult)r;
                            records.add(result.toElement());
                            result.toElement().getSchemaType().ifPresent(x -> x.properties().forEach(prop -> colNames.add(prop.getName())));
                            for (String string : result.getPropertyNames()) {
                                colNames.add(string);
                            }
                            continue;
                        }
                        if (r == null || !(r instanceof OIdentifiable) || (rec = ((OIdentifiable)r).getRecord()) == null || !(rec instanceof ODocument)) continue;
                        ODocument oDocument = (ODocument)rec;
                        records.add(oDocument);
                        for (String fieldName : oDocument.fieldNames()) {
                            colNames.add(fieldName);
                        }
                    }
                    ArrayList orderedColumns = new ArrayList(colNames);
                    try {
                        for (int col = 0; col < orderedColumns.size(); ++col) {
                            if (col > 0) {
                                iArgument.write(44);
                            }
                            iArgument.write(((String)orderedColumns.get(col)).getBytes());
                        }
                        iArgument.write(OHttpUtils.EOL);
                        for (OElement oElement : records) {
                            for (int i = 0; i < orderedColumns.size(); ++i) {
                                Object value;
                                if (i > 0) {
                                    iArgument.write(44);
                                }
                                if ((value = oElement.getProperty((String)orderedColumns.get(i))) == null) continue;
                                if (!(value instanceof Number)) {
                                    value = "\"" + value + "\"";
                                }
                                iArgument.write(value.toString().getBytes());
                            }
                            iArgument.write(OHttpUtils.EOL);
                        }
                        iArgument.flush();
                    }
                    catch (IOException e) {
                        OLogManager.instance().error((Object)this, "HTTP response: error on writing records", (Throwable)e, new Object[0]);
                    }
                    return null;
                }
            });
        } else {
            iFormat = iFormat == null ? JSON_FORMAT : "type,indent:-1,rid,version,attribSameRow,class,keepTypes,alwaysFetchEmbeddedDocuments,earlyTypes," + iFormat;
            String sendFormat = iFormat;
            if (this.isStreaming()) {
                this.sendStream(200, "OK", "application/json", null, (OCallable<Void, OChunkedResponse>)((OCallable)iArgument -> {
                    try {
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)iArgument);
                        this.writeRecordsOnStream(iFetchPlan, sendFormat, iAdditionalProperties, it, writer);
                        writer.flush();
                    }
                    catch (IOException e) {
                        OLogManager.instance().error((Object)this, "Error during writing of records to the HTTP response", (Throwable)e, new Object[0]);
                    }
                    return null;
                }));
            } else {
                StringWriter buffer = new StringWriter();
                this.writeRecordsOnStream(iFetchPlan, iFormat, iAdditionalProperties, it, buffer);
                this.send(200, "OK", "application/json", buffer.toString(), null);
            }
        }
    }

    private void writeRecordsOnStream(String iFetchPlan, String iFormat, Map<String, Object> iAdditionalProperties, Iterator<Object> it, Writer buffer) throws IOException {
        OJSONWriter json = new OJSONWriter(buffer, iFormat);
        json.beginObject();
        String format = iFetchPlan != null ? iFormat + ",fetchPlan:" + iFetchPlan : iFormat;
        json.beginCollection(-1, true, "result");
        this.formatMultiValue(it, buffer, format);
        json.endCollection(-1, true);
        if (iAdditionalProperties != null) {
            for (Map.Entry<String, Object> entry : iAdditionalProperties.entrySet()) {
                Object v = entry.getValue();
                if (OMultiValue.isMultiValue((Object)v)) {
                    json.beginCollection(-1, true, entry.getKey());
                    this.formatMultiValue(OMultiValue.getMultiValueIterator((Object)v), buffer, format);
                    json.endCollection(-1, true);
                } else {
                    json.writeAttribute(entry.getKey(), v);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
        json.endObject();
    }

    protected abstract void checkConnection() throws IOException;

    public void formatMultiValue(Iterator<?> iIterator, Writer buffer, String format) throws IOException {
        if (iIterator != null) {
            int counter = 0;
            while (iIterator.hasNext()) {
                Object entry = iIterator.next();
                if (entry != null) {
                    String objectJson;
                    if (counter++ > 0) {
                        buffer.append(", ");
                    }
                    if (entry instanceof OResult) {
                        objectJson = ((OResult)entry).toJSON();
                        buffer.append(objectJson);
                    } else if (entry instanceof OIdentifiable) {
                        ORecord rec = ((OIdentifiable)entry).getRecord();
                        if (rec != null) {
                            try {
                                objectJson = rec.toJSON(format);
                                buffer.append(objectJson);
                            }
                            catch (Exception e) {
                                OLogManager.instance().error((Object)this, "Error transforming record " + rec.getIdentity() + " to JSON", (Throwable)e, new Object[0]);
                            }
                        }
                    } else if (OMultiValue.isMultiValue(entry)) {
                        buffer.append("[");
                        this.formatMultiValue(OMultiValue.getMultiValueIterator(entry), buffer, format);
                        buffer.append("]");
                    } else {
                        buffer.append(OJSONWriter.writeValue(entry, (String)format));
                    }
                }
                this.checkConnection();
            }
        }
    }

    public void writeRecord(ORecord iRecord) throws IOException {
        this.writeRecord(iRecord, null, null);
    }

    public void writeRecord(ORecord iRecord, String iFetchPlan, String iFormat) throws IOException {
        String format;
        if (iFormat == null) {
            iFormat = JSON_FORMAT;
        }
        String string = format = iFetchPlan != null ? iFormat + ",fetchPlan:" + iFetchPlan : iFormat;
        if (iRecord != null) {
            this.send(200, "OK", "application/json", iRecord.toJSON(format), "ETag: " + iRecord.getVersion());
        }
    }

    public abstract void sendStream(int var1, String var2, String var3, InputStream var4, long var5) throws IOException;

    public abstract void sendStream(int var1, String var2, String var3, InputStream var4, long var5, String var7) throws IOException;

    public abstract void sendStream(int var1, String var2, String var3, InputStream var4, long var5, String var7, Map<String, String> var8) throws IOException;

    public abstract void sendStream(int var1, String var2, String var3, String var4, OCallable<Void, OChunkedResponse> var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compress(String jsonStr) {
        if (jsonStr == null || jsonStr.length() == 0) {
            return null;
        }
        DeflaterOutputStream gout = null;
        ByteArrayOutputStream baos = null;
        try {
            byte[] incoming = jsonStr.getBytes(StandardCharsets.UTF_8);
            baos = new ByteArrayOutputStream();
            gout = new GZIPOutputStream((OutputStream)baos, 16384);
            gout.write(incoming);
            ((GZIPOutputStream)gout).finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "Error on compressing HTTP response", (Throwable)ex, new Object[0]);
        }
        finally {
            try {
                if (gout != null) {
                    gout.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Deprecated
    public void setHeader(String iHeader) {
        this.setHeaders(iHeader);
    }

    public OutputStream getOutputStream() {
        return this.getOut();
    }

    public void flush() throws IOException {
        this.getOut().flush();
        if (!this.isKeepAlive()) {
            this.getOut().close();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public void setStaticEncoding(String contentEncoding) {
        this.staticEncoding = contentEncoding;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setJsonErrorResponse(boolean jsonErrorResponse) {
        this.jsonErrorResponse = jsonErrorResponse;
    }

    private String keyFromMapObject(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        return "" + key;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public String[] getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public void setAdditionalHeaders(String[] additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getCallbackFunction() {
        return this.callbackFunction;
    }

    public void setCallbackFunction(String callbackFunction) {
        this.callbackFunction = callbackFunction;
    }

    public String getStaticEncoding() {
        return this.staticEncoding;
    }

    public boolean isSendStarted() {
        return this.sendStarted;
    }

    public void setSendStarted(boolean sendStarted) {
        this.sendStarted = sendStarted;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isJsonErrorResponse() {
        return this.jsonErrorResponse;
    }

    public OClientConnection getConnection() {
        return this.connection;
    }

    public void setConnection(OClientConnection connection) {
        this.connection = connection;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setSameSiteCookie(boolean sameSiteCookie) {
        this.sameSiteCookie = sameSiteCookie;
    }

    public boolean isSameSiteCookie() {
        return this.sameSiteCookie;
    }

    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public void addHeader(String name, String value) {
        this.headersMap.put(name, value);
    }

    public Map<String, String> getHeadersMap() {
        return Collections.unmodifiableMap(this.headersMap);
    }
}

