/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class OAbstractRemoteTask
implements ORemoteTask {
    protected transient String nodeSource;

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public long getSynchronousTimeout(int iSynchNodes) {
        if (iSynchNodes <= 0) {
            return this.getDistributedTimeout();
        }
        return this.getDistributedTimeout() * (long)iSynchNodes;
    }

    @Override
    public long getTotalTimeout(int iTotalNodes) {
        if (iTotalNodes <= 0) {
            return this.getDistributedTimeout();
        }
        return this.getDistributedTimeout() * (long)iTotalNodes;
    }

    @Override
    public boolean hasResponse() {
        return true;
    }

    @Override
    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.ANY;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getNodeSource() {
        return this.nodeSource;
    }

    @Override
    public void setNodeSource(String nodeSource) {
        this.nodeSource = nodeSource;
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    @Override
    public boolean isNodeOnlineRequired() {
        return true;
    }

    @Override
    public boolean isUsingDatabase() {
        return true;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
    }
}

