/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class OServerCommandPostServerCommand
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"POST|servercommand"};

    public OServerCommandPostServerCommand() {
        super("server.command");
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.getUrl(), 1, "Syntax error: servercommand");
        String language = urlParts.length > 2 ? urlParts[2].trim() : "sql";
        String text = urlParts.length > 3 ? urlParts[3].trim() : iRequest.getContent();
        int limit = urlParts.length > 4 ? Integer.parseInt(urlParts[4].trim()) : -1;
        String fetchPlan = urlParts.length > 5 ? urlParts[5] : null;
        String accept = iRequest.getHeader("accept");
        Object[] params = null;
        String mode = "resultset";
        boolean returnExecutionPlan = true;
        long begin = System.currentTimeMillis();
        if (iRequest.getContent() != null && !iRequest.getContent().isEmpty()) {
            if (iRequest.getContent().startsWith("{")) {
                ODocument doc = new ODocument().fromJSON(iRequest.getContent());
                text = (String)doc.field("command");
                params = doc.field("parameters");
                if ("false".equalsIgnoreCase("" + doc.field("returnExecutionPlan"))) {
                    returnExecutionPlan = false;
                }
                if (params instanceof Collection) {
                    Object[] paramArray = new Object[((Collection)params).size()];
                    ((Collection)params).toArray(paramArray);
                    params = paramArray;
                }
            } else {
                text = iRequest.getContent();
            }
        }
        if ("false".equalsIgnoreCase("" + iRequest.getHeader("return-execution-plan"))) {
            returnExecutionPlan = false;
        }
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        iRequest.getData().commandInfo = "Command";
        iRequest.getData().commandDetail = text;
        OResultSet result = this.executeStatement(language, text, params);
        ArrayList<OResult> response = new ArrayList<OResult>();
        for (int i = 0; result.hasNext() && (limit < 0 || i < limit); ++i) {
            response.add(result.next());
        }
        HashMap<String, Object> additionalContent = new HashMap<String, Object>();
        if (returnExecutionPlan) {
            result.getExecutionPlan().ifPresent(x -> additionalContent.put("executionPlan", x.toResult().toElement()));
        }
        result.close();
        long elapsedMs = System.currentTimeMillis() - begin;
        String format = null;
        if (fetchPlan != null) {
            format = "fetchPlan:" + fetchPlan;
        }
        if (iRequest.getHeader("TE") != null) {
            iResponse.setStreaming(true);
        }
        additionalContent.put("elapsedMs", elapsedMs);
        iResponse.writeResult(response, format, accept, additionalContent, mode);
        return false;
    }

    protected OResultSet executeStatement(String language, String text, Object params) {
        OrientDB odb = this.server.getContext();
        OResultSet result = params instanceof Map ? odb.execute(text, (Map)params) : (params instanceof Object[] ? odb.execute(text, (Object[])params) : odb.execute(text, new Object[]{params}));
        return result;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

