/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ODistributedSyncConfiguration {
    private final ODistributedServerManager dManager;
    private final Map<String, OLogSequenceNumber> lastLSN = new ConcurrentHashMap<String, OLogSequenceNumber>();
    private final String databaseName;
    private final ODistributedMomentum momentum;
    private File file;
    private long lastOperationTimestamp = -1L;
    private long lastLSNWrittenOnDisk = 0L;

    public ODistributedSyncConfiguration(ODistributedServerManager manager, String databaseName, File file) throws IOException {
        this.dManager = manager;
        this.databaseName = databaseName;
        this.momentum = new ODistributedMomentum();
        this.file = file;
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
            return;
        }
        this.load();
    }

    public ODistributedMomentum getMomentum() {
        this.updateInternalDocument();
        return this.momentum;
    }

    public OLogSequenceNumber getLastLSN(String server) {
        return this.lastLSN.get(server);
    }

    public void setLastLSN(String server, OLogSequenceNumber lsn, boolean updateLastOperationTimestamp) throws IOException {
        long clusterTime;
        if (lsn == null) {
            this.lastLSN.put(server, new OLogSequenceNumber(-1L, -1L));
        } else {
            this.lastLSN.put(server, lsn);
        }
        if (updateLastOperationTimestamp && (clusterTime = this.dManager.getClusterTime()) > -1L) {
            this.lastOperationTimestamp = clusterTime;
        }
        if (System.currentTimeMillis() - this.lastLSNWrittenOnDisk > 2000L) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        try (FileInputStream is = new FileInputStream(this.file);){
            ODistributedMomentum oDistributedMomentum = this.momentum;
            synchronized (oDistributedMomentum) {
                this.momentum.fromJSON(is);
                this.lastOperationTimestamp = this.momentum.getLastOperationTimestamp();
                this.lastLSN.clear();
                for (String server : this.momentum.getServers()) {
                    this.lastLSN.put(server, this.momentum.getLSN(server));
                }
            }
        }
    }

    public void save() throws IOException {
        this.updateInternalDocument();
        this.lastLSNWrittenOnDisk = System.currentTimeMillis();
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        try (FileOutputStream os = new FileOutputStream(this.file, false);){
            this.momentum.toJSON(os);
        }
    }

    public long getLastOperationTimestamp() {
        return this.lastOperationTimestamp;
    }

    protected void updateInternalDocument() {
        this.momentum.setLastOperationTimestamp(this.lastOperationTimestamp);
        for (Map.Entry<String, OLogSequenceNumber> entry : this.lastLSN.entrySet()) {
            this.momentum.setLSN(entry.getKey(), entry.getValue());
        }
    }

    public void removeServer(String nodeName) throws IOException {
        if (this.lastLSN.remove(nodeName) != null) {
            this.save();
        }
    }
}

