/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.server.OServer;

public class OServerShutdownHook
extends Thread {
    private final OServer server;

    protected OServerShutdownHook(OServer server) {
        this.server = server;
        Orient.instance().removeShutdownHook();
        Runtime.getRuntime().addShutdownHook(this);
    }

    @Override
    public void run() {
        if (this.server != null) {
            try {
                if (!this.server.shutdown()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            finally {
                OLogManager.instance().shutdown();
            }
        }
    }

    public void cancel() {
        try {
            Runtime.getRuntime().removeShutdownHook(this);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

