/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.strategy;

import com.orientechnologies.spatial.engine.OLuceneSpatialIndexContainer;
import com.orientechnologies.spatial.query.OSpatialQueryContext;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilderAbstract;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class SpatialQueryBuilderDistanceSphere
extends SpatialQueryBuilderAbstract {
    public static final String NAME = "distance_sphere";

    public SpatialQueryBuilderDistanceSphere(OLuceneSpatialIndexContainer manager, OShapeBuilder factory) {
        super(manager, factory);
    }

    @Override
    public OSpatialQueryContext build(Map<String, Object> query) throws Exception {
        Shape shape = this.parseShape(query);
        SpatialStrategy strategy = this.manager.strategy();
        Number distance = (Number)query.get("distance");
        SpatialArgs args = new SpatialArgs(SpatialOperation.Intersects, (Shape)this.factory.context().makeCircle((Point)shape, DistanceUtils.dist2Degrees((double)(distance.doubleValue() / 1000.0), (double)6371.0087714)));
        Query filterQuery = strategy.makeQuery(args);
        IndexSearcher searcher = this.manager.searcher();
        DoubleValuesSource valueSource = strategy.makeDistanceValueSource((Point)shape);
        Sort distSort = new Sort(valueSource.getSortField(false)).rewrite(searcher);
        BooleanQuery q = new BooleanQuery.Builder().add(filterQuery, BooleanClause.Occur.MUST).add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD).build();
        return new OSpatialQueryContext(null, searcher, (Query)q, Arrays.asList(distSort.getSort())).setSpatialArgs(args);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

