/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OShapeType;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.context.jts.ValidationRule;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.locationtech.spatial4j.shape.jts.JtsShapeFactory;

public abstract class OShapeBuilder<T extends Shape> {
    public static final String COORDINATES = "coordinates";
    public static final String BASE_CLASS = "OShape";
    protected static final JtsSpatialContext SPATIAL_CONTEXT;
    protected static final GeometryFactory GEOMETRY_FACTORY;
    protected static final JtsShapeFactory SHAPE_FACTORY;
    protected static final WKTReader wktReader;
    private static final Map<String, Integer> capStyles;
    private static final Map<String, Integer> join;
    private static final DecimalFormat doubleFormat;

    public synchronized String format(double value) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (Double.isInfinite(value)) {
            if (value > 0.0) {
                return "Inf";
            }
            return "-Inf";
        }
        return doubleFormat.format(value);
    }

    public abstract String getName();

    public abstract OShapeType getType();

    public abstract T fromDoc(ODocument var1);

    public T fromObject(Object obj) {
        throw new UnsupportedOperationException();
    }

    public T fromMapGeoJson(Map<String, Object> geoJsonMap) {
        ODocument doc = new ODocument(this.getName());
        doc.field(COORDINATES, geoJsonMap.get(COORDINATES));
        return this.fromDoc(doc);
    }

    public abstract void initClazz(ODatabaseInternal var1);

    public String asText(T shape) {
        return SHAPE_FACTORY.getGeometryFrom(shape).toText();
    }

    public byte[] asBinary(T shape) {
        WKBWriter writer = new WKBWriter();
        Geometry geom = SHAPE_FACTORY.getGeometryFrom(shape);
        return writer.write(geom);
    }

    public String asText(ODocument document) {
        return this.asText(this.fromDoc(document));
    }

    public String asText(Map<String, Object> geoJson) {
        return this.asText(this.fromMapGeoJson(geoJson));
    }

    public String asText(Object object) {
        throw new UnsupportedOperationException();
    }

    public String asGeoJson(T shape) {
        return SPATIAL_CONTEXT.getFormats().getGeoJsonWriter().toString(shape);
    }

    public String asGeoJson(ODocument document) {
        return this.asGeoJson(this.fromDoc(document));
    }

    public ODocument fromGeoJson(String geoJson) throws IOException, java.text.ParseException {
        Shape shape = SPATIAL_CONTEXT.getFormats().getGeoJsonReader().read((Object)geoJson);
        return this.toDoc(shape);
    }

    public void validate(ODocument doc) {
    }

    Geometry toGeometry(Shape shape) {
        return SHAPE_FACTORY.getGeometryFrom(shape);
    }

    public JtsGeometry toShape(Geometry geometry) {
        return SHAPE_FACTORY.makeShape(geometry);
    }

    protected OClass superClass(ODatabaseInternal db) {
        return db.getMetadata().getSchema().getClass(BASE_CLASS);
    }

    public T fromText(String wkt) throws java.text.ParseException, ParseException {
        Shape entity = SPATIAL_CONTEXT.getWktShapeParser().parse(wkt);
        if (entity instanceof Rectangle) {
            Geometry geometryFrom = SHAPE_FACTORY.getGeometryFrom(entity);
            entity = SHAPE_FACTORY.makeShape(geometryFrom);
        }
        return (T)entity;
    }

    public abstract ODocument toDoc(T var1);

    protected ODocument toDoc(T parsed, Geometry geometry) {
        if (geometry == null || Double.isNaN(geometry.getCoordinates()[0].getZ())) {
            return this.toDoc(parsed);
        }
        throw new IllegalArgumentException("Invalid shape");
    }

    public ODocument toDoc(String wkt) throws java.text.ParseException, ParseException {
        T parsed = this.fromText(wkt);
        return this.toDoc(parsed, OGlobalConfiguration.SPATIAL_ENABLE_DIRECT_WKT_READER.getValueAsBoolean() ? wktReader.read(wkt) : null);
    }

    public int getSRID(Shape shape) {
        Geometry geometry = this.toGeometry(shape);
        return geometry.getSRID();
    }

    public Shape buffer(Shape shape, Double distance, Map<String, Object> params) {
        Geometry geometry = this.toGeometry(shape);
        BufferParameters parameters = new BufferParameters();
        if (params != null) {
            this.bindParameters(parameters, params);
        }
        BufferOp ops = new BufferOp(geometry, parameters);
        return this.toShape(ops.getResultGeometry(distance.doubleValue()));
    }

    private void bindParameters(BufferParameters parameters, Map<String, Object> params) {
        this.bindQuad(parameters, params);
        this.bindMitre(parameters, params);
        this.bindCap(parameters, params);
        this.bindJoin(parameters, params);
    }

    private void bindCap(BufferParameters parameters, Map<String, Object> params) {
        Integer style;
        String endCap = (String)params.get("endCap");
        if (endCap != null && (style = capStyles.get(endCap)) != null) {
            parameters.setEndCapStyle(style.intValue());
        }
    }

    private void bindJoin(BufferParameters parameters, Map<String, Object> params) {
        Integer style;
        String join = (String)params.get("join");
        if (join != null && (style = OShapeBuilder.join.get(join)) != null) {
            parameters.setJoinStyle(style.intValue());
        }
    }

    private void bindMitre(BufferParameters parameters, Map<String, Object> params) {
        Number mitre = (Number)params.get("mitre");
        if (mitre != null) {
            parameters.setMitreLimit(mitre.doubleValue());
        }
    }

    private void bindQuad(BufferParameters parameters, Map<String, Object> params) {
        Number quadSegs = (Number)params.get("quadSegs");
        if (quadSegs != null) {
            parameters.setQuadrantSegments(quadSegs.intValue());
        }
    }

    public SpatialContext context() {
        return SPATIAL_CONTEXT;
    }

    static {
        wktReader = new WKTReader();
        capStyles = new HashMap<String, Integer>();
        join = new HashMap<String, Integer>();
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.geo = true;
        factory.validationRule = ValidationRule.none;
        SPATIAL_CONTEXT = new JtsSpatialContext(factory);
        SHAPE_FACTORY = new JtsShapeFactory(SPATIAL_CONTEXT, factory);
        GEOMETRY_FACTORY = SHAPE_FACTORY.getGeometryFactory();
        capStyles.put("round", 1);
        capStyles.put("flat", 2);
        capStyles.put("square", 1);
        join.put("round", 1);
        join.put("mitre", 2);
        join.put("bevel", 3);
        DecimalFormatSymbols sym = new DecimalFormatSymbols();
        sym.setDecimalSeparator('.');
        doubleFormat = new DecimalFormat("0", sym);
        doubleFormat.setMaximumFractionDigits(16);
    }
}

