/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.shape.Point;

public class OPointShapeBuilder
extends OShapeBuilder<Point> {
    public static final String NAME = "OPoint";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public OShapeType getType() {
        return OShapeType.POINT;
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass point = schema.createAbstractClass(this.getName(), this.superClass(db));
        OProperty coordinates = point.createProperty("coordinates", OType.EMBEDDEDLIST, OType.DOUBLE);
        coordinates.setMin("2");
        coordinates.setMax("2");
        if (OGlobalConfiguration.SPATIAL_ENABLE_DIRECT_WKT_READER.getValueAsBoolean()) {
            OClass pointz = schema.createAbstractClass(this.getName() + "Z", this.superClass(db));
            OProperty coordinatesz = pointz.createProperty("coordinates", OType.EMBEDDEDLIST, OType.DOUBLE);
            coordinatesz.setMin("3");
            coordinatesz.setMax("3");
        }
    }

    @Override
    public Point fromDoc(ODocument document) {
        this.validate(document);
        List coordinates = (List)document.field("coordinates");
        if (coordinates.size() == 2) {
            return SHAPE_FACTORY.pointXY(((Number)coordinates.get(0)).doubleValue(), ((Number)coordinates.get(1)).doubleValue());
        }
        return SHAPE_FACTORY.pointXYZ(((Number)coordinates.get(0)).doubleValue(), ((Number)coordinates.get(1)).doubleValue(), ((Number)coordinates.get(2)).doubleValue());
    }

    @Override
    public ODocument toDoc(final Point shape) {
        ODocument doc = new ODocument(this.getName());
        doc.field("coordinates", (Object)new ArrayList<Double>(){
            {
                this.add(shape.getX());
                this.add(shape.getY());
            }
        });
        return doc;
    }

    @Override
    protected ODocument toDoc(Point parsed, final Geometry geometry) {
        if (geometry == null || Double.isNaN(geometry.getCoordinate().getZ())) {
            return this.toDoc(parsed);
        }
        ODocument doc = new ODocument(this.getName() + "Z");
        doc.field("coordinates", (Object)new ArrayList<Double>(){
            {
                this.add(geometry.getCoordinate().getX());
                this.add(geometry.getCoordinate().getY());
                this.add(geometry.getCoordinate().getZ());
            }
        });
        return doc;
    }

    @Override
    public String asText(ODocument document) {
        if (document.getClassName().equals("OPointZ")) {
            List coordinates = (List)document.getProperty("coordinates");
            return "POINT Z (" + this.format((Double)coordinates.get(0)) + " " + this.format((Double)coordinates.get(1)) + " " + this.format((Double)coordinates.get(2)) + ")";
        }
        return super.asText(document);
    }
}

