/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OComplexShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class OMultiLineStringShapeBuilder
extends OComplexShapeBuilder<JtsGeometry> {
    @Override
    public String getName() {
        return "OMultiLineString";
    }

    @Override
    public OShapeType getType() {
        return OShapeType.MULTILINESTRING;
    }

    @Override
    public JtsGeometry fromDoc(ODocument document) {
        this.validate(document);
        List coordinates = (List)document.field("coordinates");
        LineString[] multiLine = new LineString[coordinates.size()];
        int j = 0;
        for (List coordinate : coordinates) {
            multiLine[j] = this.createLineString(coordinate);
            ++j;
        }
        return this.toShape((Geometry)GEOMETRY_FACTORY.createMultiLineString(multiLine));
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass lineString = schema.createAbstractClass(this.getName(), this.superClass(db));
        lineString.createProperty("coordinates", OType.EMBEDDEDLIST, OType.EMBEDDEDLIST);
        if (OGlobalConfiguration.SPATIAL_ENABLE_DIRECT_WKT_READER.getValueAsBoolean()) {
            OClass lineStringZ = schema.createAbstractClass(this.getName() + "Z", this.superClass(db));
            lineStringZ.createProperty("coordinates", OType.EMBEDDEDLIST, OType.EMBEDDEDLIST);
        }
    }

    @Override
    public ODocument toDoc(JtsGeometry shape) {
        MultiLineString geom = (MultiLineString)shape.getGeom();
        ArrayList<List<List<Double>>> coordinates = new ArrayList<List<List<Double>>>();
        ODocument doc = new ODocument(this.getName());
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            LineString lineString = (LineString)geom.getGeometryN(i);
            coordinates.add(this.coordinatesFromLineString(lineString));
        }
        doc.field("coordinates", coordinates);
        return doc;
    }

    @Override
    protected ODocument toDoc(JtsGeometry shape, Geometry geometry) {
        if (geometry == null || Double.isNaN(geometry.getCoordinates()[0].getZ())) {
            return this.toDoc(shape);
        }
        ArrayList<List<List<Double>>> coordinates = new ArrayList<List<List<Double>>>();
        ODocument doc = new ODocument(this.getName() + "Z");
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            LineString lineString = (LineString)geometry.getGeometryN(i);
            coordinates.add(this.coordinatesFromLineStringZ((Geometry)lineString));
        }
        doc.field("coordinates", coordinates);
        return doc;
    }

    @Override
    public String asText(ODocument document) {
        if (document.getClassName().equals("OMultiLineStringZ")) {
            List coordinates = (List)document.getProperty("coordinates");
            String result = coordinates.stream().map(line -> "(" + line.stream().map(point -> point.stream().map(coord -> this.format((double)coord)).collect(Collectors.joining(" "))).collect(Collectors.joining(", ")) + ")").collect(Collectors.joining(", "));
            return "MULTILINESTRING Z(" + result + ")";
        }
        return super.asText(document);
    }
}

