/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OComplexShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class OLineStringShapeBuilder
extends OComplexShapeBuilder<JtsGeometry> {
    @Override
    public String getName() {
        return "OLineString";
    }

    @Override
    public OShapeType getType() {
        return OShapeType.LINESTRING;
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass lineString = schema.createAbstractClass(this.getName(), this.superClass(db));
        lineString.createProperty("coordinates", OType.EMBEDDEDLIST, OType.EMBEDDEDLIST);
        if (OGlobalConfiguration.SPATIAL_ENABLE_DIRECT_WKT_READER.getValueAsBoolean()) {
            OClass lineStringZ = schema.createAbstractClass(this.getName() + "Z", this.superClass(db));
            lineStringZ.createProperty("coordinates", OType.EMBEDDEDLIST, OType.EMBEDDEDLIST);
        }
    }

    @Override
    public JtsGeometry fromDoc(ODocument document) {
        this.validate(document);
        List coordinates = (List)document.field("coordinates");
        Coordinate[] coords = new Coordinate[coordinates.size()];
        int i = 0;
        for (List coordinate : coordinates) {
            coords[i] = new Coordinate(((Number)coordinate.get(0)).doubleValue(), ((Number)coordinate.get(1)).doubleValue());
            ++i;
        }
        return this.toShape((Geometry)GEOMETRY_FACTORY.createLineString(coords));
    }

    @Override
    public ODocument toDoc(JtsGeometry shape) {
        ODocument doc = new ODocument(this.getName());
        LineString lineString = (LineString)shape.getGeom();
        doc.field("coordinates", this.coordinatesFromLineString(lineString));
        return doc;
    }

    @Override
    protected ODocument toDoc(JtsGeometry shape, Geometry geometry) {
        if (geometry == null || Double.isNaN(geometry.getCoordinate().getZ())) {
            return this.toDoc(shape);
        }
        ODocument doc = new ODocument(this.getName() + "Z");
        doc.field("coordinates", this.coordinatesFromLineStringZ(geometry));
        return doc;
    }

    @Override
    public String asText(ODocument document) {
        if (document.getClassName().equals("OLineStringZ")) {
            List coordinates = (List)document.getProperty("coordinates");
            String result = coordinates.stream().map(point -> point.stream().map(coord -> this.format((double)coord)).collect(Collectors.joining(" "))).collect(Collectors.joining(", "));
            return "LINESTRING Z (" + result + ")";
        }
        return super.asText(document);
    }
}

