/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.functions;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import com.orientechnologies.spatial.shape.OShapeFactory;

public class OSTGeomFromGeoJSONFunction
extends OSQLFunctionAbstract {
    public static final String NAME = "ST_GeomFromGeoJSON";
    private OShapeFactory factory = OShapeFactory.INSTANCE;

    public OSTGeomFromGeoJSONFunction() {
        super(NAME, 1, 1);
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        String geom = (String)iParams[0];
        try {
            return this.factory.fromGeoJson(geom);
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OCommandExecutionException(String.format("Cannot parse geometry {%s}", geom)), (Throwable)e);
        }
    }

    public String getSyntax() {
        return null;
    }
}

